/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemFluidHandler;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MEFluidHandler
implements IStorageSystemFluidHandler {
    @NotNull
    private final MEStorage storageMonitor;
    @NotNull
    private final IActionSource actionSource;

    public MEFluidHandler(@NotNull MEStorage storageMonitor, @NotNull IActionSource actionSource) {
        this.storageMonitor = storageMonitor;
        this.actionSource = actionSource;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        AEFluidKey itemKey = AEFluidKey.of((Fluid)resource.getFluid());
        long inserted = this.storageMonitor.insert((AEKey)itemKey, (long)resource.getAmount(), action == IFluidHandler.FluidAction.SIMULATE ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        return (int)Math.min(inserted, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public FluidStack drain(FluidFilter filter, IFluidHandler.FluidAction simulate) {
        Pair<Long, AEFluidKey> fluidKey = AEApi.findAEFluidFromFilter(this.storageMonitor, null, filter);
        if (fluidKey.getRight() == null) {
            return FluidStack.EMPTY;
        }
        long extracted = this.storageMonitor.extract((AEKey)fluidKey.getRight(), (long)filter.getCount(), simulate == IFluidHandler.FluidAction.SIMULATE ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        return new FluidStack(fluidKey.getRight().getFluid(), (int)Math.min(extracted, Integer.MAX_VALUE));
    }
}

