/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemChemicalHandler;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import org.jetbrains.annotations.NotNull;

public class MEChemicalHandler
implements IStorageSystemChemicalHandler {
    @NotNull
    private final MEStorage storageMonitor;
    @NotNull
    private final IActionSource actionSource;

    public MEChemicalHandler(@NotNull MEStorage storageMonitor, @NotNull IActionSource actionSource) {
        this.storageMonitor = storageMonitor;
        this.actionSource = actionSource;
    }

    @NotNull
    public ChemicalStack insertChemical(int tank, ChemicalStack resource, @NotNull Action action) {
        if (resource.isEmpty()) {
            return resource;
        }
        ChemicalStack remain = resource.copy();
        long amountInserted = this.storageMonitor.insert((AEKey)MekanismKey.of((ChemicalStack)resource), resource.getAmount(), action == Action.SIMULATE ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        remain.setAmount(resource.getAmount() - amountInserted);
        return remain;
    }

    @Override
    @NotNull
    public ChemicalStack extractChemical(ChemicalFilter filter, long count, Action simulate) {
        Pair<Long, MekanismKey> chemicalKey = AEApi.findAEChemicalFromFilter(this.storageMonitor, null, filter);
        if (chemicalKey.getRight() == null) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack extracted = chemicalKey.getRight().getStack();
        long amountExtracted = this.storageMonitor.extract((AEKey)chemicalKey.getRight(), count, simulate == Action.SIMULATE ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        extracted.setAmount(amountExtracted);
        AdvancedPeripherals.debug("Extracted chemical: " + String.valueOf(extracted) + " from filter: " + String.valueOf(filter));
        return extracted;
    }
}

