/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.recipes.block.AbstractBiomeParameterRecipe;
import com.aetherteam.nitrogen.recipe.BlockPropertyPair;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.aetherteam.nitrogen.recipe.recipes.AbstractBlockStateRecipe;
import com.aetherteam.nitrogen.recipe.serializer.BlockStateRecipeSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeParameterRecipeSerializer<T extends AbstractBiomeParameterRecipe>
extends BlockStateRecipeSerializer<T> {
    private final Factory<T> factory;
    private final MapCodec<T> codec;

    public BiomeParameterRecipeSerializer(Factory<T> factory, AbstractBlockStateRecipe.Factory<T> superFactory) {
        super(superFactory);
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockStateRecipeUtil.KEY_CODEC.optionalFieldOf("biome").forGetter(AbstractBiomeParameterRecipe::getBiome), (App)BlockStateIngredient.CODEC.fieldOf("ingredient").forGetter(AbstractBlockStateRecipe::getIngredient), (App)BlockPropertyPair.CODEC.fieldOf("result").forGetter(AbstractBlockStateRecipe::getResult), (App)ResourceLocation.CODEC.optionalFieldOf("mcfunction").forGetter(AbstractBlockStateRecipe::getFunctionId)).apply((Applicative)inst, factory::create));
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public T fromNetwork(RegistryFriendlyByteBuf buffer) {
        Optional biome = buffer.readOptional(buf -> (Either)BlockStateRecipeUtil.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf)));
        BlockStateIngredient ingredient = (BlockStateIngredient)BlockStateIngredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        BlockPropertyPair result = BlockStateRecipeUtil.readPair((FriendlyByteBuf)buffer);
        Optional function = buffer.readOptional(FriendlyByteBuf::readResourceLocation);
        return this.factory.create(biome, ingredient, result, function);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeOptional(((AbstractBiomeParameterRecipe)((Object)recipe)).getBiome(), (buf, either) -> BlockStateRecipeUtil.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf), either));
        super.toNetwork(buffer, recipe);
    }

    public static interface Factory<T extends AbstractBiomeParameterRecipe> {
        public T create(Optional<Either<ResourceKey<Biome>, TagKey<Biome>>> var1, BlockStateIngredient var2, BlockPropertyPair var3, Optional<ResourceLocation> var4);
    }
}

