/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.goal;

import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.monster.dungeon.boss.Slider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CollideGoal
extends Goal {
    private final Slider slider;

    public CollideGoal(Slider slider) {
        this.slider = slider;
    }

    public boolean canUse() {
        if (!this.slider.isAwake() || this.slider.isDeadOrDying()) {
            return false;
        }
        return this.slider.attackCooldown() <= 0 || this.slider.getDeltaMovement().length() > 0.08;
    }

    public void tick() {
        Vec3 min = new Vec3(this.slider.getBoundingBox().minX - 0.1, this.slider.getBoundingBox().minY - 0.1, this.slider.getBoundingBox().minZ - 0.1);
        Vec3 max = new Vec3(this.slider.getBoundingBox().maxX + 0.1, this.slider.getBoundingBox().maxY + 0.1, this.slider.getBoundingBox().maxZ + 0.1);
        AABB collisionBounds = new AABB(min, max);
        for (Entity entity : this.slider.level().getEntities((Entity)this.slider, collisionBounds)) {
            Player player;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity.hurt(AetherDamageTypes.entityDamageSource(this.slider.level(), AetherDamageTypes.CRUSH, (Entity)this.slider), 6.0f)) {
                    Player player2;
                    if (livingEntity instanceof Player && (player2 = (Player)livingEntity).getUseItem().is(Items.SHIELD) && player2.isBlocking()) {
                        player2.getCooldowns().addCooldown(Items.SHIELD, 100);
                        player2.stopUsingItem();
                        this.slider.level().broadcastEntityEvent((Entity)player2, (byte)30);
                    }
                    entity.setDeltaMovement(entity.getDeltaMovement().multiply(4.0, 1.0, 4.0).add(0.0, 0.25, 0.0));
                    this.slider.setMoveDelay(this.slider.calculateMoveDelay());
                    this.slider.setAttackCooldown(20);
                    this.slider.setMoveDirection(null);
                    this.slider.playSound(this.slider.getCollideSound(), 2.5f, 1.0f / (this.slider.getRandom().nextFloat() * 0.2f + 0.9f));
                    this.slider.setDeltaMovement(Vec3.ZERO);
                    continue;
                }
            }
            if (entity instanceof Player && (player = (Player)entity).isCreative() || entity instanceof Slider) continue;
            entity.setDeltaMovement(this.slider.getDeltaMovement().multiply(4.0, 1.0, 4.0).add(0.0, 0.25, 0.0));
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

