/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.generators;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.advancement.IncubationTrigger;
import com.aetherteam.aether.advancement.LoreTrigger;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.data.resources.registries.AetherMoaTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.loot.AetherLoot;
import com.aetherteam.aether.mixin.mixins.common.accessor.HoeItemAccessor;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.StartRidingTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class AetherAdvancementData
extends AdvancementProvider {
    public AetherAdvancementData(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper helper) {
        super(output, registries, helper, List.of(new AetherAdvancements()));
    }

    private static ItemUsedOnLocationTrigger.TriggerInstance itemUsedOnLocationCheckAbove(LocationPredicate.Builder location, LocationPredicate.Builder above, ItemPredicate.Builder item) {
        ContextAwarePredicate contextawarepredicate = ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{LocationCheck.checkLocation((LocationPredicate.Builder)location).build(), LocationCheck.checkLocation((LocationPredicate.Builder)above, (BlockPos)BlockPos.ZERO.above()).build(), MatchTool.toolMatches((ItemPredicate.Builder)item).build()});
        return new ItemUsedOnLocationTrigger.TriggerInstance(Optional.empty(), Optional.of(contextawarepredicate));
    }

    public static Criterion<ItemUsedOnLocationTrigger.TriggerInstance> itemUsedOnBlockCheckAbove(LocationPredicate.Builder location, LocationPredicate.Builder above, ItemPredicate.Builder item) {
        return CriteriaTriggers.ITEM_USED_ON_BLOCK.createCriterion((CriterionTriggerInstance)AetherAdvancementData.itemUsedOnLocationCheckAbove(location, above, item));
    }

    public static class AetherAdvancements
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            AdvancementHolder theAether = Advancement.Builder.advancement().display((ItemLike)AetherItems.AETHER_PORTAL_FRAME.get(), (Component)Component.translatable((String)"advancement.aether.the_aether"), (Component)Component.translatable((String)"advancement.aether.the_aether.desc"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/block/dungeon/carved_stone.png"), AdvancementType.TASK, false, false, false).addCriterion("the_aether", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(AetherDimensions.AETHER_LEVEL)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"the_aether"), existingFileHelper);
            AdvancementHolder enterAether = Advancement.Builder.advancement().parent(theAether).display((ItemLike)Blocks.GLOWSTONE, (Component)Component.translatable((String)"advancement.aether.enter_aether"), (Component)Component.translatable((String)"advancement.aether.enter_aether.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("enter_aether", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(AetherDimensions.AETHER_LEVEL)).rewards(new AdvancementRewards(0, List.of(AetherLoot.ENTER_AETHER), List.of(), Optional.empty())).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"enter_aether"), existingFileHelper);
            AdvancementHolder readLore = Advancement.Builder.advancement().parent(enterAether).display((ItemLike)AetherItems.BOOK_OF_LORE.get(), (Component)Component.translatable((String)"advancement.aether.read_lore"), (Component)Component.translatable((String)"advancement.aether.read_lore.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("lore_book_entry", LoreTrigger.Instance.forAny()).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"read_lore"), existingFileHelper);
            AdvancementHolder loreception = Advancement.Builder.advancement().parent(readLore).display((ItemLike)AetherItems.BOOK_OF_LORE.get(), (Component)Component.translatable((String)"advancement.aether.loreception"), (Component)Component.translatable((String)"advancement.aether.loreception.desc"), null, AdvancementType.GOAL, true, true, true).addCriterion("lore_book_entry", LoreTrigger.Instance.forItem((ItemLike)AetherItems.BOOK_OF_LORE.get())).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"loreception"), existingFileHelper);
            AdvancementHolder zanite = Advancement.Builder.advancement().parent(enterAether).display((ItemLike)AetherItems.ZANITE_GEMSTONE.get(), (Component)Component.translatable((String)"advancement.aether.zanite"), (Component)Component.translatable((String)"advancement.aether.zanite.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("zanite", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.ZANITE_GEMSTONE.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"zanite"), existingFileHelper);
            AdvancementHolder craftAltar = Advancement.Builder.advancement().parent(zanite).display((ItemLike)AetherBlocks.ALTAR.get(), (Component)Component.translatable((String)"advancement.aether.craft_altar"), (Component)Component.translatable((String)"advancement.aether.craft_altar.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("craft_altar", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.ALTAR.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"craft_altar"), existingFileHelper);
            AdvancementHolder icestone = Advancement.Builder.advancement().parent(craftAltar).display((ItemLike)AetherBlocks.ICESTONE.get(), (Component)Component.translatable((String)"advancement.aether.icestone"), (Component)Component.translatable((String)"advancement.aether.icestone.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("icestone", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.ICESTONE.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"icestone"), existingFileHelper);
            AdvancementHolder iceAccessory = Advancement.Builder.advancement().parent(icestone).display((ItemLike)AetherItems.ICE_PENDANT.get(), (Component)Component.translatable((String)"advancement.aether.ice_accessory"), (Component)Component.translatable((String)"advancement.aether.ice_accessory.desc"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("ice_pendant", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.ICE_PENDANT.get()})).addCriterion("ice_ring", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.ICE_RING.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"ice_accessory"), existingFileHelper);
            AdvancementHolder blueAercloud = Advancement.Builder.advancement().parent(enterAether).display((ItemLike)AetherBlocks.BLUE_AERCLOUD.get(), (Component)Component.translatable((String)"advancement.aether.blue_aercloud"), (Component)Component.translatable((String)"advancement.aether.blue_aercloud.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("blue_aercloud", EnterBlockTrigger.TriggerInstance.entersBlock((Block)((Block)AetherBlocks.BLUE_AERCLOUD.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"blue_aercloud"), existingFileHelper);
            AdvancementHolder obtainEgg = Advancement.Builder.advancement().parent(blueAercloud).display((ItemLike)AetherItems.BLUE_MOA_EGG.get(), (Component)Component.translatable((String)"advancement.aether.obtain_egg"), (Component)Component.translatable((String)"advancement.aether.obtain_egg.desc"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("moa_egg", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(AetherTags.Items.MOA_EGGS).build()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"obtain_egg"), existingFileHelper);
            AdvancementHolder obtainPetal = Advancement.Builder.advancement().parent(obtainEgg).display((ItemLike)AetherItems.AECHOR_PETAL.get(), (Component)Component.translatable((String)"advancement.aether.obtain_petal"), (Component)Component.translatable((String)"advancement.aether.obtain_petal.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("aechor_petal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.AECHOR_PETAL.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"obtain_petal"), existingFileHelper);
            AdvancementHolder preventAechorPlantSpawning = Advancement.Builder.advancement().parent(obtainPetal).display((ItemLike)AetherBlocks.PURPLE_FLOWER.get(), (Component)Component.translatable((String)"advancement.aether.prevent_aechor_petal_spawning"), (Component)Component.translatable((String)"advancement.aether.prevent_aechor_petal_spawning.desc"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("place_flower", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(AetherTags.Blocks.ENCHANTED_GRASS)), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(AetherTags.Items.AECHOR_PLANT_SPAWNABLE_DETERRENT))).addCriterion("enchant_grass", AetherAdvancementData.itemUsedOnBlockCheckAbove(LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(AetherTags.Blocks.ENCHANTED_GRASS)), LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(AetherTags.Blocks.AECHOR_PLANT_SPAWNABLE_DETERRENT)), ItemPredicate.Builder.item().of(new ItemLike[]{AetherItems.AMBROSIUM_SHARD}))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"prevent_aechor_petal_spawning"), existingFileHelper);
            AdvancementHolder preventSwetSpawning = Advancement.Builder.advancement().parent(preventAechorPlantSpawning).display(AetherItems.createSwetBannerItemStack((HolderGetter<BannerPattern>)provider.lookupOrThrow(Registries.BANNER_PATTERN)), (Component)Component.translatable((String)"advancement.aether.prevent_swet_spawning"), (Component)Component.translatable((String)"advancement.aether.prevent_swet_spawning.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("place_banner", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location(), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.BLACK_BANNER}).hasComponents(DataComponentPredicate.allOf((DataComponentMap)AetherItems.createSwetBannerItemStack((HolderGetter<BannerPattern>)provider.lookupOrThrow(Registries.BANNER_PATTERN)).getComponents())))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"prevent_swet_spawning"), existingFileHelper);
            AdvancementHolder incubateMoa = Advancement.Builder.advancement().parent(obtainEgg).display((ItemLike)AetherBlocks.INCUBATOR.get(), (Component)Component.translatable((String)"advancement.aether.incubate_moa"), (Component)Component.translatable((String)"advancement.aether.incubate_moa.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("incubate_moa", IncubationTrigger.Instance.forItem(ItemPredicate.Builder.item().of(AetherTags.Items.MOA_EGGS).build())).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"incubate_moa"), existingFileHelper);
            CompoundTag moaTag = new CompoundTag();
            moaTag.putString("MoaType", AetherMoaTypes.BLACK.location().toString());
            AdvancementHolder blackMoa = Advancement.Builder.advancement().parent(incubateMoa).display((ItemLike)Items.FEATHER, (Component)Component.translatable((String)"advancement.aether.black_moa"), (Component)Component.translatable((String)"advancement.aether.black_moa.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("black_moa", StartRidingTrigger.TriggerInstance.playerStartsRiding((EntityPredicate.Builder)EntityPredicate.Builder.entity().vehicle(EntityPredicate.Builder.entity().of((EntityType)AetherEntityTypes.MOA.get()).nbt(new NbtPredicate(moaTag))))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"black_moa"), existingFileHelper);
            AdvancementHolder mountPhyg = Advancement.Builder.advancement().parent(blueAercloud).display((ItemLike)Items.SADDLE, (Component)Component.translatable((String)"advancement.aether.mount_phyg"), (Component)Component.translatable((String)"advancement.aether.mount_phyg.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("mount_phyg", StartRidingTrigger.TriggerInstance.playerStartsRiding((EntityPredicate.Builder)EntityPredicate.Builder.entity().vehicle(EntityPredicate.Builder.entity().of((EntityType)AetherEntityTypes.PHYG.get())))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"mount_phyg"), existingFileHelper);
            AdvancementHolder enchantedGravitite = Advancement.Builder.advancement().parent(craftAltar).display((ItemLike)AetherBlocks.ENCHANTED_GRAVITITE.get(), (Component)Component.translatable((String)"advancement.aether.enchanted_gravitite"), (Component)Component.translatable((String)"advancement.aether.enchanted_gravitite.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("enchanted_gravitite", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherBlocks.ENCHANTED_GRAVITITE.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"enchanted_gravitite"), existingFileHelper);
            AdvancementHolder gravititeArmor = Advancement.Builder.advancement().parent(enchantedGravitite).display((ItemLike)AetherItems.GRAVITITE_CHESTPLATE.get(), (Component)Component.translatable((String)"advancement.aether.gravitite_armor"), (Component)Component.translatable((String)"advancement.aether.gravitite_armor.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("gravitite_helmet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.GRAVITITE_HELMET.get()})).addCriterion("gravitite_chestplate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.GRAVITITE_CHESTPLATE.get()})).addCriterion("gravitite_leggings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.GRAVITITE_LEGGINGS.get()})).addCriterion("gravitite_boots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.GRAVITITE_BOOTS.get()})).addCriterion("gravitite_gloves", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.GRAVITITE_GLOVES.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"gravitite_armor"), existingFileHelper);
            AdvancementHolder bronzeDungeon = Advancement.Builder.advancement().parent(enchantedGravitite).display((ItemLike)AetherItems.BRONZE_DUNGEON_KEY.get(), (Component)Component.translatable((String)"advancement.aether.bronze_dungeon"), (Component)Component.translatable((String)"advancement.aether.bronze_dungeon.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("kill_slider", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)AetherEntityTypes.SLIDER.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"bronze_dungeon"), existingFileHelper);
            AdvancementHolder hammerLoot = Advancement.Builder.advancement().parent(bronzeDungeon).display((ItemLike)AetherItems.HAMMER_OF_KINGBDOGZ.get(), (Component)Component.translatable((String)"advancement.aether.hammer_loot"), (Component)Component.translatable((String)"advancement.aether.hammer_loot.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("hammer_loot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.HAMMER_OF_KINGBDOGZ.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"hammer_loot"), existingFileHelper);
            AdvancementHolder zephyrHammer = Advancement.Builder.advancement().parent(hammerLoot).display((ItemLike)Items.SNOWBALL, (Component)Component.translatable((String)"advancement.aether.zephyr_hammer"), (Component)Component.translatable((String)"advancement.aether.zephyr_hammer.desc"), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("zephyr_hammer", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)AetherEntityTypes.ZEPHYR.get()), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of((EntityType)AetherEntityTypes.HAMMER_PROJECTILE.get())))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"zephyr_hammer"), existingFileHelper);
            AdvancementHolder lanceLoot = Advancement.Builder.advancement().parent(bronzeDungeon).display((ItemLike)AetherItems.VALKYRIE_LANCE.get(), (Component)Component.translatable((String)"advancement.aether.lance_loot"), (Component)Component.translatable((String)"advancement.aether.lance_loot.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("lance_loot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_LANCE.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"lance_loot"), existingFileHelper);
            AdvancementHolder silverDungeon = Advancement.Builder.advancement().parent(lanceLoot).display((ItemLike)AetherItems.SILVER_DUNGEON_KEY.get(), (Component)Component.translatable((String)"advancement.aether.silver_dungeon"), (Component)Component.translatable((String)"advancement.aether.silver_dungeon.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("kill_valkyrie_queen", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)AetherEntityTypes.VALKYRIE_QUEEN.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"silver_dungeon"), existingFileHelper);
            AdvancementHolder valkyrieLoot = Advancement.Builder.advancement().parent(silverDungeon).display((ItemLike)AetherItems.VALKYRIE_HELMET.get(), (Component)Component.translatable((String)"advancement.aether.valkyrie_loot"), (Component)Component.translatable((String)"advancement.aether.valkyrie_loot.desc"), null, AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("valkyrie_pickaxe", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_PICKAXE.get()})).addCriterion("valkyrie_hoe", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_HOE.get()})).addCriterion("valkyrie_axe", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_AXE.get()})).addCriterion("valkyrie_shovel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_SHOVEL.get()})).addCriterion("valkyrie_helmet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_HELMET.get()})).addCriterion("valkyrie_chestplate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_CHESTPLATE.get()})).addCriterion("valkyrie_leggings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_LEGGINGS.get()})).addCriterion("valkyrie_boots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_BOOTS.get()})).addCriterion("valkyrie_gloves", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_GLOVES.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"valkyrie_loot"), existingFileHelper);
            AdvancementHolder valkyrieHoe = Advancement.Builder.advancement().parent(valkyrieLoot).display((ItemLike)AetherBlocks.AETHER_FARMLAND.get(), (Component)Component.translatable((String)"advancement.aether.valkyrie_hoe"), (Component)Component.translatable((String)"advancement.aether.valkyrie_hoe.desc"), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("valkyrie_hoe", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(Stream.concat(AbilityHooks.ToolHooks.TILLABLES.keySet().stream(), HoeItemAccessor.aether$getTillables().keySet().stream().sorted(Comparator.comparing(Block::getDescriptionId))).toList())), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)AetherItems.VALKYRIE_HOE.get()}))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"valkyrie_hoe"), existingFileHelper);
            AdvancementHolder regenStone = Advancement.Builder.advancement().parent(silverDungeon).display((ItemLike)AetherItems.REGENERATION_STONE.get(), (Component)Component.translatable((String)"advancement.aether.regen_stone"), (Component)Component.translatable((String)"advancement.aether.regen_stone.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("regen_stone", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.REGENERATION_STONE.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"regen_stone"), existingFileHelper);
            AdvancementHolder goldDungeon = Advancement.Builder.advancement().parent(regenStone).display((ItemLike)AetherItems.GOLD_DUNGEON_KEY.get(), (Component)Component.translatable((String)"advancement.aether.gold_dungeon"), (Component)Component.translatable((String)"advancement.aether.gold_dungeon.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("kill_sun_spirit", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)AetherEntityTypes.SUN_SPIRIT.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"gold_dungeon"), existingFileHelper);
            AdvancementHolder phoenixArmor = Advancement.Builder.advancement().parent(goldDungeon).display((ItemLike)AetherItems.PHOENIX_HELMET.get(), (Component)Component.translatable((String)"advancement.aether.phoenix_armor"), (Component)Component.translatable((String)"advancement.aether.phoenix_armor.desc"), null, AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("phoenix_helmet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.PHOENIX_HELMET.get()})).addCriterion("phoenix_chestplate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.PHOENIX_CHESTPLATE.get()})).addCriterion("phoenix_leggings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.PHOENIX_LEGGINGS.get()})).addCriterion("phoenix_boots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.PHOENIX_BOOTS.get()})).addCriterion("phoenix_gloves", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.PHOENIX_GLOVES.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"phoenix_armor"), existingFileHelper);
            AdvancementHolder obsidianArmor = Advancement.Builder.advancement().parent(phoenixArmor).display((ItemLike)AetherItems.OBSIDIAN_CHESTPLATE.get(), (Component)Component.translatable((String)"advancement.aether.obsidian_armor"), (Component)Component.translatable((String)"advancement.aether.obsidian_armor.desc"), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("obsidian_helmet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.OBSIDIAN_HELMET.get()})).addCriterion("obsidian_chestplate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.OBSIDIAN_CHESTPLATE.get()})).addCriterion("obsidian_leggings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.OBSIDIAN_LEGGINGS.get()})).addCriterion("obsidian_boots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.OBSIDIAN_BOOTS.get()})).addCriterion("obsidian_gloves", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AetherItems.OBSIDIAN_GLOVES.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"obsidian_armor"), existingFileHelper);
            AdvancementHolder aetherSleep = Advancement.Builder.advancement().parent(goldDungeon).display((ItemLike)AetherBlocks.SKYROOT_BED.get(), (Component)Component.translatable((String)"advancement.aether.aether_sleep"), (Component)Component.translatable((String)"advancement.aether.aether_sleep.desc"), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("aether_sleep", CriteriaTriggers.SLEPT_IN_BED.createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().located(LocationPredicate.Builder.inDimension(AetherDimensions.AETHER_LEVEL))))))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"aether_sleep"), existingFileHelper);
        }
    }
}

