/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.monster.Zephyr;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ZephyrModel
extends EntityModel<Zephyr> {
    public final ModelPart rightFace;
    public final ModelPart leftFace;
    public final ModelPart mouth;
    public final ModelPart body;
    public final ModelPart bodyRightSideFront;
    public final ModelPart bodyRightSideBack;
    public final ModelPart bodyLeftSideFront;
    public final ModelPart bodyLeftSideBack;
    public final ModelPart cloudButt;
    public final ModelPart tailBase;
    public final ModelPart tailMiddle;
    public final ModelPart tailEnd;

    public ZephyrModel(ModelPart model) {
        this.rightFace = model.getChild("right_face");
        this.leftFace = model.getChild("left_face");
        this.mouth = model.getChild("mouth");
        this.body = model.getChild("body");
        this.bodyRightSideFront = model.getChild("body_right_side_front");
        this.bodyRightSideBack = model.getChild("body_right_side_back");
        this.bodyLeftSideFront = model.getChild("body_left_side_front");
        this.bodyLeftSideBack = model.getChild("body_left_side_back");
        this.cloudButt = model.getChild("cloud_butt");
        this.tailBase = model.getChild("tail_base");
        this.tailMiddle = this.tailBase.getChild("tail_middle");
        this.tailEnd = this.tailMiddle.getChild("tail_end");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("right_face", CubeListBuilder.create().texOffs(67, 11).addBox(-7.0f, -1.0f, -9.0f, 4.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_face", CubeListBuilder.create().texOffs(67, 11).mirror().addBox(3.0f, -1.0f, -9.0f, 4.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(66, 19).mirror().addBox(-3.0f, 1.0f, -8.0f, 6.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(27, 9).addBox(-6.0f, -4.0f, -7.0f, 12.0f, 9.0f, 14.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("body_right_side_front", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-2.0f, -3.0f, -3.0f, 2.0f, 6.0f, 6.0f), PartPose.offset((float)-6.0f, (float)8.0f, (float)-4.0f));
        partDefinition.addOrReplaceChild("body_right_side_back", CubeListBuilder.create().texOffs(25, 11).mirror().addBox(-2.0f, -3.3333f, -2.5f, 2.0f, 6.0f, 6.0f), PartPose.offset((float)-5.5f, (float)9.0f, (float)2.0f));
        partDefinition.addOrReplaceChild("body_left_side_front", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, -3.0f, -3.0f, 2.0f, 6.0f, 6.0f), PartPose.offset((float)6.0f, (float)8.0f, (float)-4.0f));
        partDefinition.addOrReplaceChild("body_left_side_back", CubeListBuilder.create().texOffs(25, 11).addBox(0.0f, -3.3333f, -2.5f, 2.0f, 6.0f, 6.0f), PartPose.offset((float)5.5f, (float)9.0f, (float)2.0f));
        partDefinition.addOrReplaceChild("cloud_butt", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-6.0f, -3.0f, 0.0f, 8.0f, 6.0f, 2.0f), PartPose.offset((float)2.0f, (float)8.0f, (float)7.0f));
        PartDefinition tailBase = partDefinition.addOrReplaceChild("tail_base", CubeListBuilder.create().texOffs(96, 22).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)12.4f));
        PartDefinition tailMiddle = tailBase.addOrReplaceChild("tail_middle", CubeListBuilder.create().texOffs(80, 24).addBox(-2.0f, -2.0f, -1.966667f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        tailMiddle.addOrReplaceChild("tail_end", CubeListBuilder.create().texOffs(84, 18).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)32);
    }

    public void setupAnim(Zephyr zephyr, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float motion = Mth.sin((float)(limbSwing * 20.0f / 57.295776f)) * limbSwingAmount * 0.5f;
        this.rightFace.y = 8.0f - motion;
        this.rightFace.x = -motion * 0.5f;
        this.leftFace.y = motion + 8.0f;
        this.leftFace.x = motion * 0.5f;
        this.bodyRightSideFront.y = 8.0f - motion * 0.5f;
        this.bodyRightSideBack.y = 9.0f + motion * 0.5f;
        this.bodyLeftSideFront.y = this.bodyRightSideFront.y;
        this.bodyLeftSideBack.y = this.bodyRightSideBack.y;
        this.tailBase.x = Mth.sin((float)(limbSwing * 20.0f / 57.295776f)) * limbSwingAmount * 0.75f;
        this.tailBase.y = 8.0f - motion;
        this.tailBase.yRot = Mth.sin((float)(ageInTicks * 0.5f)) * limbSwingAmount * 0.75f;
        this.tailMiddle.x = Mth.sin((float)(limbSwing * 15.0f / 57.295776f)) * limbSwingAmount * 0.85f;
        this.tailMiddle.y = motion * 1.25f;
        this.tailMiddle.yRot = this.tailBase.yRot + 0.25f;
        this.tailEnd.x = Mth.sin((float)(limbSwing * 10.0f / 57.295776f)) * limbSwingAmount * 0.95f;
        this.tailEnd.y = -motion;
        this.tailEnd.yRot = this.tailMiddle.yRot + 0.35f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int color) {
        this.rightFace.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.leftFace.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.mouth.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.bodyRightSideFront.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.bodyRightSideBack.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.bodyLeftSideFront.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.bodyLeftSideBack.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.cloudButt.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.tailBase.render(poseStack, consumer, packedLight, packedOverlay, color);
    }
}

