/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.inventory;

import com.aetherteam.aether.client.gui.component.inventory.LorePageButton;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LoreBookScreen
extends AbstractContainerScreen<LoreBookMenu> {
    private static final ResourceLocation TEXTURE_LORE_BACKING = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/gui/menu/lore_backing.png");
    private static final ResourceLocation TEXTURE_LORE_BOOK = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/gui/menu/lore_book.png");
    private final Map<Integer, List<FormattedCharSequence>> pages = new HashMap<Integer, List<FormattedCharSequence>>();
    private LorePageButton previousButton;
    private LorePageButton nextButton;
    private int currentPageNumber;
    private ItemStack lastStack;

    public LoreBookScreen(LoreBookMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 256;
        this.imageHeight = 199;
    }

    protected void init() {
        super.init();
        int xPos = (this.width - this.getXSize()) / 2;
        int yPos = (this.height - this.getYSize()) / 2;
        this.previousButton = (LorePageButton)this.addRenderableWidget((GuiEventListener)new LorePageButton(new Button.Builder((Component)Component.literal((String)"<"), button -> {
            if (this.currentPageNumber > 0) {
                --this.currentPageNumber;
            }
        }).bounds(xPos + 14, yPos + 169, 20, 20)));
        this.nextButton = (LorePageButton)this.addRenderableWidget((GuiEventListener)new LorePageButton(new Button.Builder((Component)Component.literal((String)">"), button -> {
            if (this.currentPageNumber < this.pages.size() - 1) {
                ++this.currentPageNumber;
            }
        }).bounds(xPos + 221, yPos + 169, 20, 20)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        String entryKey;
        MutableComponent previous = Component.translatable((String)"gui.aether.book_of_lore.previous");
        MutableComponent next = Component.translatable((String)"gui.aether.book_of_lore.next");
        this.drawNormalBookText(guiGraphics, this.font, (Component)previous, 13, 158);
        this.drawNormalBookText(guiGraphics, this.font, (Component)next, 221, 158);
        MutableComponent book = Component.translatable((String)"gui.aether.book_of_lore.book");
        MutableComponent ofLore = Component.translatable((String)"gui.aether.book_of_lore.of_lore");
        this.drawCenteredBookText(guiGraphics, this.font, (Component)book, 75, 20);
        this.drawCenteredBookText(guiGraphics, this.font, (Component)ofLore, 75, 30);
        MutableComponent item = Component.translatable((String)"gui.aether.book_of_lore.item");
        this.drawRightBookText(guiGraphics, this.font, (Component)item, 78, 67);
        ItemStack itemStack = ((Slot)((LoreBookMenu)this.getMenu()).slots.getFirst()).getItem();
        if (!itemStack.isEmpty() && I18n.exists((String)(entryKey = ((LoreBookMenu)this.getMenu()).getLoreEntryKey(itemStack)))) {
            MutableComponent entry = Component.translatable((String)entryKey);
            this.createPages((Component)entry);
            if (this.currentPageNumber == 0) {
                MutableComponent title = itemStack.getHoverName().plainCopy();
                this.createText(guiGraphics, this.font.split((FormattedText)title, 98), 136, 10);
                this.createText(guiGraphics, this.pages.get(0), 136, 32);
            } else {
                this.createText(guiGraphics, this.pages.get(this.currentPageNumber), 136, 10);
            }
        }
        if (itemStack.isEmpty() || !itemStack.is(this.lastStack.getItem())) {
            this.pages.clear();
            this.currentPageNumber = 0;
        }
        this.previousButton.active = this.currentPageNumber > 0;
        this.nextButton.active = this.currentPageNumber < this.pages.size() - 1;
        this.lastStack = itemStack;
    }

    private void createPages(Component loreEntry) {
        ArrayList formattedText = new ArrayList(this.font.split((FormattedText)loreEntry, 98));
        if (formattedText.size() < 6) {
            List firstPage = formattedText.subList(0, formattedText.size());
            this.pages.put(0, firstPage);
        } else {
            List firstPage = formattedText.subList(0, 6);
            this.pages.put(0, firstPage);
            List remainingPages = formattedText.subList(6, formattedText.size());
            List list = Lists.partition(remainingPages, (int)8);
            for (int i = 1; i < list.size() + 1; ++i) {
                this.pages.put(i, (List)list.get(i - 1));
            }
        }
    }

    private void createText(GuiGraphics guiGraphics, List<FormattedCharSequence> reorderingProcessors, int x, int y) {
        int length = 0;
        for (FormattedCharSequence line : reorderingProcessors) {
            this.drawBookText(guiGraphics, this.font, line, x, y + length * 10);
            ++length;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        int xPos = (this.width - this.getXSize()) / 2;
        int yPos = (this.height - this.getYSize()) / 2;
        guiGraphics.blit(TEXTURE_LORE_BACKING, xPos, yPos - 4, 0.0f, 0.0f, this.getXSize(), this.getYSize() + 56, 256, 256);
        guiGraphics.blit(TEXTURE_LORE_BOOK, xPos + 12, yPos + 2, 0.0f, 0.0f, this.getXSize(), this.getYSize() + 56, 256, 256);
    }

    private void drawNormalBookText(GuiGraphics guiGraphics, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.getVisualOrderText();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x, y);
    }

    private void drawRightBookText(GuiGraphics guiGraphics, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.getVisualOrderText();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x - fontRenderer.width(sequence), y);
    }

    private void drawCenteredBookText(GuiGraphics guiGraphics, Font fontRenderer, Component component, int x, int y) {
        FormattedCharSequence sequence = component.getVisualOrderText();
        this.drawBookText(guiGraphics, fontRenderer, sequence, x - fontRenderer.width(sequence) / 2, y);
    }

    private void drawBookText(GuiGraphics guiGraphics, Font fontRenderer, FormattedCharSequence sequence, int x, int y) {
        guiGraphics.drawString(fontRenderer, sequence, x, y, 0x404040, false);
    }
}

