/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.component.dialogue;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class DialogueAnswerComponent {
    private final List<NpcDialogueElement> splitLines = new ArrayList<NpcDialogueElement>();
    public int height;

    public DialogueAnswerComponent(Component message) {
        this.updateDialogue(message);
    }

    public void render(GuiGraphics guiGraphics) {
        this.splitLines.forEach(element -> element.render(guiGraphics));
    }

    public void reposition(int width, int height) {
        int i = 0;
        for (NpcDialogueElement dialogue : this.splitLines) {
            dialogue.width = Minecraft.getInstance().font.width(dialogue.text) + 2;
            dialogue.x = width / 2 - dialogue.width / 2;
            dialogue.y = height / 2 + i * 12;
            ++i;
        }
        this.height = this.splitLines.size() * 12;
    }

    public void updateDialogue(Component message) {
        this.splitLines.clear();
        List list = Minecraft.getInstance().font.split((FormattedText)message, 300);
        this.height = list.size() * 12;
        list.forEach(text -> this.splitLines.add(new NpcDialogueElement(0, 0, 0, (FormattedCharSequence)text)));
    }

    public static class NpcDialogueElement {
        private final FormattedCharSequence text;
        private int x;
        private int y;
        private int width;

        public NpcDialogueElement(int x, int y, int width, FormattedCharSequence text) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.width = width;
        }

        public void render(GuiGraphics guiGraphics) {
            guiGraphics.fillGradient(this.x, this.y, this.x + this.width, this.y + 12, 0x66000000, 0x66000000);
            guiGraphics.drawString(Minecraft.getInstance().font, this.text, this.x + 1, this.y + 1, 0xFFFFFF);
        }
    }
}

