/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.miscellaneous.MoaEggItem;
import com.aetherteam.aether.mixin.mixins.client.accessor.BlockColorsAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class AetherColorResolvers {
    private static final int AETHER_GRASS_COLOR = 11665355;
    private static final int ENCHANTED_GRASS_COLOR = 16575076;

    public static void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        HashMap<Block, BlockColor> map = new HashMap<Block, BlockColor>();
        Map<Block, BlockColor> blockColors = ((BlockColorsAccessor)event.getBlockColors()).aether$getBlockColors();
        map.put(Blocks.SHORT_GRASS, blockColors.get(Blocks.SHORT_GRASS));
        map.put(Blocks.FERN, blockColors.get(Blocks.FERN));
        map.put(Blocks.TALL_GRASS, blockColors.get(Blocks.TALL_GRASS));
        map.put(Blocks.LARGE_FERN, blockColors.get(Blocks.LARGE_FERN));
        for (Map.Entry entry : map.entrySet()) {
            event.register((state, level, pos, tintIndex) -> {
                if (level != null && pos != null) {
                    BlockPos newPos = state.hasProperty((Property)DoublePlantBlock.HALF) ? (state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos) : pos;
                    BlockPos baseBlock = newPos.below();
                    if (level.getBlockState(baseBlock).is(AetherTags.Blocks.ENCHANTED_GRASS)) {
                        return 16575076;
                    }
                    if (level.getBlockState(baseBlock).is((Block)AetherBlocks.AETHER_GRASS_BLOCK.get())) {
                        return 11665355;
                    }
                }
                return ((BlockColor)entry.getValue()).getColor(state, level, pos, tintIndex);
            }, new Block[]{(Block)entry.getKey()});
        }
    }

    public static void registerItemColor(RegisterColorHandlersEvent.Item event) {
        event.register((color, itemProvider) -> itemProvider > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)color, (int)-6265536), new ItemLike[]{(ItemLike)AetherItems.LEATHER_GLOVES.get()});
        for (MoaEggItem moaEggItem : MoaEggItem.moaEggs()) {
            event.register((color, itemProvider) -> FastColor.ARGB32.opaque((int)moaEggItem.getColor()), new ItemLike[]{moaEggItem});
        }
    }
}

