/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.natural;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.natural.LeavesWithParticlesBlock;
import com.aetherteam.aether.item.AetherItems;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class CrystalFruitLeavesBlock
extends LeavesWithParticlesBlock {
    public CrystalFruitLeavesBlock(Supplier<? extends ParticleOptions> particle, BlockBehaviour.Properties properties) {
        super(particle, properties);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)AetherConfig.SERVER.crystal_leaves_consistency.get()).booleanValue()) {
            CrystalFruitLeavesBlock.dropResources(state, level, pos, null, (Entity)player, ItemStack.EMPTY, true);
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.getRandom().nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)((Block)AetherBlocks.CRYSTAL_LEAVES.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)((Boolean)state.getValue((Property)AetherBlockStateProperties.DOUBLE_DROPS))), 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public static void dropResources(BlockState state, Level level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, ItemStack tool, boolean dropXp) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CrystalFruitLeavesBlock.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)tool).forEach(itemStack -> {
                if (itemStack.getItem() != AetherItems.SKYROOT_STICK.get()) {
                    CrystalFruitLeavesBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStack);
                }
            });
            state.spawnAfterBreak(serverLevel, pos, tool, dropXp);
        }
    }
}

