/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block;

import com.aetherteam.aether.event.FreezeEvent;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import java.util.Optional;
import net.minecraft.commands.CacheableFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public interface FreezingBehavior<T> {
    public static final int FLAG_SHELL = 3;
    public static final int FLAG_VOLUME = 19;

    default public int freezeBlocks(Level level, BlockPos origin, T source, float radius) {
        float radiusSq = radius * radius;
        int blocksFrozen = 0;
        for (int x = (int)radius; x >= 0; --x) {
            boolean firstXZ = true;
            for (int z = (int)radius; z >= 0; --z) {
                int xzLengthSq = x * x + z * z;
                if ((float)xzLengthSq > radiusSq) continue;
                blocksFrozen += this.quarters(level, origin, x, 0, z, source, firstXZ ? 3 : 19);
                firstXZ = false;
                boolean firstY = true;
                for (int y = (int)radius; y >= 0; --y) {
                    if ((float)(xzLengthSq + y * y) > radiusSq) continue;
                    int placementFlag = firstY ? 3 : 19;
                    blocksFrozen += this.quarters(level, origin, x, y, z, source, placementFlag);
                    blocksFrozen += this.quarters(level, origin, x, -y, z, source, placementFlag);
                    firstY = false;
                }
            }
        }
        return this.freezeFromRecipe(level, origin, origin, source, 3) + blocksFrozen;
    }

    private int quarters(Level level, BlockPos origin, int dX, int dY, int dZ, T source, int flag) {
        return this.freezeFromRecipe(level, origin.offset(dX, dY, dZ), origin, source, flag) + this.freezeFromRecipe(level, origin.offset(-dZ, dY, dX), origin, source, flag) + this.freezeFromRecipe(level, origin.offset(-dX, dY, -dZ), origin, source, flag) + this.freezeFromRecipe(level, origin.offset(dZ, dY, -dX), origin, source, flag);
    }

    public int freezeFromRecipe(Level var1, BlockPos var2, BlockPos var3, T var4, int var5);

    default public int freezeBlockAt(Level level, BlockPos pos, BlockPos origin, BlockState oldBlockState, BlockState newBlockState, Optional<CacheableFunction> function, T source, int flag) {
        FreezeEvent event = this.onFreeze((LevelAccessor)level, pos, origin, oldBlockState, newBlockState, source);
        if (!event.isCanceled()) {
            level.setBlock(pos, newBlockState, flag);
            if (newBlockState.isRandomlyTicking()) {
                level.scheduleTick(pos, newBlockState.getBlock(), Mth.nextInt((RandomSource)level.getRandom(), (int)60, (int)120));
            }
            BlockStateRecipeUtil.executeFunction((Level)level, (BlockPos)pos, function);
            return 1;
        }
        return 0;
    }

    public FreezeEvent onFreeze(LevelAccessor var1, BlockPos var2, BlockPos var3, BlockState var4, BlockState var5, T var6);
}

