/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;

public class RenderAdvQuarry
implements BlockEntityRenderer<AdvQuarryEntity> {
    public RenderAdvQuarry(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(AdvQuarryEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public void render(AdvQuarryEntity quarry, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Minecraft.getInstance().getProfiler().push("quarryplus");
        if (quarry.renderMode().equals("frame")) {
            Minecraft.getInstance().getProfiler().push("adv_quarry");
            Area range = quarry.getArea();
            if (range != null) {
                Minecraft.getInstance().getProfiler().push("rendering");
                double d = 0.0625;
                TextureAtlasSprite sprite = Sprites.INSTANCE.getWhite();
                ColorBox color = new ColorBox(255, 255, 0, 255);
                VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.cutout());
                BlockPos pos = quarry.getBlockPos();
                LocalPlayer player = Minecraft.getInstance().player;
                double playerX = player == null ? (double)pos.getX() : player.getX();
                double playerZ = player == null ? (double)pos.getZ() : player.getZ();
                matrices.pushPose();
                matrices.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
                double startX = (double)range.minX() + 0.5;
                double startZ = (double)range.minZ() + 0.5;
                double endZ = (double)range.maxZ() + 0.5;
                double endX = (double)range.maxX() + 0.5;
                boolean b1 = Math.abs(playerZ - startZ) < 256.0;
                boolean b2 = Math.abs(playerZ - endZ) < 256.0;
                boolean b3 = Math.abs(playerX - startX) < 256.0;
                boolean b4 = Math.abs(playerX - endX) < 256.0;
                double xMin = Math.max(startX, playerX - 128.0);
                double xMax = Math.min(endX, playerX + 128.0);
                double zMin = Math.max(startZ, playerZ - 128.0);
                double zMax = Math.min(endZ, playerZ + 128.0);
                if (b1) {
                    Box.apply(xMin, range.minY(), startZ, xMax, range.minY(), startZ, xMax - xMin, 0.0625, 0.0625, false, false).render(buffer, matrices, sprite, color);
                }
                if (b2) {
                    Box.apply(xMin, range.minY(), endZ, xMax, range.minY(), endZ, xMax - xMin, 0.0625, 0.0625, false, false).render(buffer, matrices, sprite, color);
                }
                if (b3) {
                    Box.apply(startX, range.minY(), zMin, startX, range.minY(), zMax, 0.0625, 0.0625, zMax - zMin, false, false).render(buffer, matrices, sprite, color);
                }
                if (b4) {
                    Box.apply(endX, range.minY(), zMin, endX, range.minY(), zMax, 0.0625, 0.0625, zMax - zMin, false, false).render(buffer, matrices, sprite, color);
                }
                matrices.popPose();
                Minecraft.getInstance().getProfiler().pop();
            }
            Minecraft.getInstance().getProfiler().pop();
        }
        Minecraft.getInstance().getProfiler().pop();
    }
}

