/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.CombinedBlockEntityTicker;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.machine.quarry.QuarryEntity;
import com.yogpc.qp.machine.quarry.QuarryState;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class QuarryBlock
extends QpEntityBlock {
    public static final String NAME = "quarry";

    protected QuarryBlock(Function<QpBlock, ? extends BlockItem> itemGenerator) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).strength(1.5f, 10.0f).sound(SoundType.STONE), NAME, itemGenerator);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{QpBlockProperty.WORKING, BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getPlayer() == null ? Direction.NORTH : ctx.getPlayer().getDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return QuarryBlock.createTickerHelper(blockEntityType, this.getBlockEntityType().orElse(null), CombinedBlockEntityTicker.of(this, level, QuarryEntity::clientTick));
        }
        return QuarryBlock.createTickerHelper(blockEntityType, this.getBlockEntityType().orElse(null), CombinedBlockEntityTicker.of(this, level, PowerEntity.logTicker(), QuarryEntity::serverTick, MachineStorage.pushItemTicker(), MachineStorage.pushFluidTicker()));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        QuarryEntity entity = this.getBlockEntityType().map(t -> (QuarryEntity)t.getBlockEntity((BlockGetter)level, pos)).orElse(null);
        if (entity != null) {
            if (!level.isClientSide()) {
                if (entity.enabled) {
                    this.openGui((ServerPlayer)player, level, pos, entity);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.getName()}), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected abstract void openGui(ServerPlayer var1, Level var2, BlockPos var3, QuarryEntity var4);

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof QuarryEntity) {
            QuarryEntity quarry = (QuarryEntity)blockEntity;
            quarry.updateMaxEnergyWithEnchantment(level);
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            QuarryMarker.Link markerLink = Stream.of(facing.getOpposite(), facing.getCounterClockWise(), facing.getClockWise()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).map(arg_0 -> ((Level)level).getBlockEntity(arg_0)).filter(QuarryMarker.class::isInstance).map(QuarryMarker.class::cast).flatMap(m -> m.getLink().stream()).findAny().orElseGet(() -> {
                BlockPos base = pos.relative(facing.getOpposite());
                BlockPos corner1 = base.relative(facing.getClockWise(), 5).above(4);
                BlockPos corner2 = base.relative(facing.getCounterClockWise(), 5).relative(facing.getOpposite(), 10);
                Area area = new Area((Vec3i)corner1, (Vec3i)corner2, facing.getOpposite());
                return new QuarryMarker.StaticLink(area);
            });
            Area area = Area.assumeY(markerLink.area());
            if (!area.quarryDigPosIterator(pos.getY()).hasNext()) {
                QuarryPlus.LOGGER.warn(QuarryEntity.MARKER, "The area for quarry({}) doesn't have enough space for work. Area: {}", (Object)pos.toShortString(), (Object)area);
                if (placer instanceof Player) {
                    Player p = (Player)placer;
                    String text = "This Quarry doesn't have enough space for work";
                    p.displayClientMessage((Component)Component.literal((String)text).withStyle(ChatFormatting.RED), false);
                }
                return;
            }
            quarry.setArea(area);
            markerLink.drops().forEach(quarry.storage::addItem);
            markerLink.remove(level);
            quarry.setState(QuarryState.WAITING, state);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        this.getBlockEntityType().map(t -> (QuarryEntity)t.getBlockEntity((BlockGetter)level, pos)).ifPresent(e -> e.saveToItem(stack, (HolderLookup.Provider)level.registryAccess()));
        return stack;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof QuarryEntity) {
            QuarryEntity entity = (QuarryEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)entity.moduleInventory);
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CustomData tag = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (tag != null && tag.contains("storage")) {
            tooltipComponents.add((Component)Component.literal((String)"DON'T PLACE THIS INTO WORLD.").withStyle(ChatFormatting.RED));
            tooltipComponents.add((Component)Component.literal((String)"This block might cause crash.").withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public Stream<ItemStack> creativeTabItem(CreativeModeTab.ItemDisplayParameters parameters) {
        Stream.Builder<ItemStack> builder = Stream.builder();
        ItemStack stack = new ItemStack((ItemLike)this);
        builder.add(stack);
        HolderLookup.RegistryLookup lookup = parameters.holders().lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference efficiency = lookup.getOrThrow(Enchantments.EFFICIENCY);
        Holder.Reference unbreaking = lookup.getOrThrow(Enchantments.UNBREAKING);
        Holder.Reference fortune = lookup.getOrThrow(Enchantments.FORTUNE);
        Holder.Reference silkTouch = lookup.getOrThrow(Enchantments.SILK_TOUCH);
        ItemStack e = stack.copy();
        e.enchant((Holder)efficiency, 5);
        builder.add(e);
        e = stack.copy();
        e.enchant((Holder)efficiency, 5);
        e.enchant((Holder)unbreaking, 3);
        e.enchant((Holder)fortune, 3);
        builder.add(e);
        e = stack.copy();
        e.enchant((Holder)efficiency, 5);
        e.enchant((Holder)unbreaking, 3);
        e.enchant((Holder)silkTouch, 1);
        builder.add(e);
        return builder.build();
    }
}

