/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.module;

import com.yogpc.qp.machine.module.QuarryModule;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public sealed interface QuarryModuleProvider {

    public static non-sealed interface Item
    extends QuarryModuleProvider {
        public QuarryModule getModule(@NotNull ItemStack var1);
    }

    public static non-sealed interface Block
    extends QuarryModuleProvider {
        public QuarryModule getModule(@NotNull Level var1, BlockPos var2, BlockState var3);

        public static Set<QuarryModule> getModulesInWorld(@NotNull Level level, @NotNull BlockPos pos) {
            return Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).mapMulti(Block.findModule(level)).collect(Collectors.toSet());
        }

        private static BiConsumer<BlockPos, Consumer<QuarryModule>> findModule(@NotNull Level level) {
            return (pos, consumer) -> {
                BlockState state = level.getBlockState(pos);
                net.minecraft.world.level.block.Block patt0$temp = state.getBlock();
                if (patt0$temp instanceof Block) {
                    Block block = (Block)patt0$temp;
                    consumer.accept(block.getModule(level, (BlockPos)pos, state));
                }
            };
        }
    }
}

