/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.marker.FlexibleMarkerEntity;
import com.yogpc.qp.machine.marker.FlexibleMarkerMessage;
import com.yogpc.qp.machine.marker.MarkerContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class FlexibleMarkerScreen
extends AbstractContainerScreen<MarkerContainer> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"textures/gui/flex_marker.png");
    private final FlexibleMarkerEntity marker;
    private static final int yOffsetCenter = 35;
    private static final int yOffsetLR = 55;
    private static final int yOffsetBottom = 78;
    private static final int buttonWidth = 20;
    private static final int buttonHeight = 14;
    private final List<MovablePosition> movablePositions = new ArrayList<MovablePosition>();
    private final List<DiffPosition> diffPositions = new ArrayList<DiffPosition>();

    public FlexibleMarkerScreen(MarkerContainer menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 217;
        this.imageHeight = 220;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
        this.marker = (FlexibleMarkerEntity)playerInventory.player.level().getBlockEntity(menu.pos);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int pX = this.leftPos;
        int pY = this.topPos;
        graphics.blit(LOCATION, pX, pY, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void init() {
        super.init();
        this.movablePositions.add(new MovablePosition(FlexibleMarkerEntity.Movable.UP, this.imageWidth / 2, 6));
        this.movablePositions.add(new MovablePosition(FlexibleMarkerEntity.Movable.FORWARD, this.imageWidth / 2, 41));
        this.movablePositions.add(new MovablePosition(FlexibleMarkerEntity.Movable.LEFT, 48, 61));
        this.movablePositions.add(new MovablePosition(FlexibleMarkerEntity.Movable.RIGHT, this.imageWidth - 8 - 40, 61));
        this.movablePositions.add(new MovablePosition(FlexibleMarkerEntity.Movable.DOWN, this.imageWidth / 2, 84));
        this.diffPositions.add(new DiffPosition((Component)Component.literal((String)"--"), -40, 0, -16));
        this.diffPositions.add(new DiffPosition((Component)Component.literal((String)"-"), -20, 0, -1));
        this.diffPositions.add(new DiffPosition((Component)Component.literal((String)"+"), 0, 0, 1));
        this.diffPositions.add(new DiffPosition((Component)Component.literal((String)"++"), 20, 0, 16));
        for (MovablePosition movablePosition : this.movablePositions) {
            for (DiffPosition diffPosition : this.diffPositions) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)diffPosition.title, (Button.OnPress)this.onPress(movablePosition, diffPosition.amount)).pos(this.leftPos + movablePosition.baseX + diffPosition.x, this.topPos + movablePosition.baseY + diffPosition.y + 10).size(20, 14).tooltip(Tooltip.create((Component)Component.translatable((String)movablePosition.movable.transName).append(String.format(" %+d", diffPosition.amount)))).build());
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        int heightOffset = 26;
        for (MovablePosition movablePosition : this.movablePositions) {
            MutableComponent text = Component.translatable((String)movablePosition.movable.transName);
            int textLength = this.font.width((FormattedText)text);
            guiGraphics.drawString(this.font, (Component)text, movablePosition.baseX - textLength / 2, movablePosition.baseY, 0x404040, false);
            int distance = movablePosition.movable.distanceFromOrigin(this.marker.getBlockPos(), this.marker.min, this.marker.max, this.marker.direction);
            String text2 = String.valueOf(distance);
            int textLength2 = this.font.width(text2);
            guiGraphics.drawString(this.font, text2, movablePosition.baseX - textLength2 / 2, movablePosition.baseY + 26, 0x404040, false);
        }
    }

    Button.OnPress onPress(MovablePosition movablePosition, int amount) {
        return button -> PlatformAccess.getAccess().packetHandler().sendToServer(new FlexibleMarkerMessage(this.marker, movablePosition.movable, amount));
    }

    private record MovablePosition(FlexibleMarkerEntity.Movable movable, int baseX, int baseY) {
    }

    private record DiffPosition(Component title, int x, int y, int amount) {
    }
}

