/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.marker.ChunkMarkerBlock;
import com.yogpc.qp.machine.marker.FlexibleMarkerBlock;
import java.lang.reflect.Constructor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

abstract sealed class ExMarkerBlock
extends QpEntityBlock
permits FlexibleMarkerBlock, ChunkMarkerBlock {
    private static final VoxelShape STANDING_Shape = Shapes.box((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);

    public ExMarkerBlock(BlockBehaviour.Properties properties, String name) {
        super(properties, name, b -> new BlockItem((Block)b, new Item.Properties()));
    }

    @Override
    protected QpBlock createBlock(BlockBehaviour.Properties properties) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (QpBlock)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            QuarryPlus.LOGGER.error("Can't get new instance of {}", (Object)this.getClass().getName(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STANDING_Shape;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.UP;
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        return state.canSurvive((LevelReader)world, currentPos) ? state : Blocks.AIR.defaultBlockState();
    }

    public abstract void setPlacedBy(Level var1, BlockPos var2, BlockState var3, @Nullable LivingEntity var4, ItemStack var5);

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof QpEntity) {
            QpEntity entity = (QpEntity)blockEntity;
            if (!level.isClientSide()) {
                if (entity.enabled) {
                    PlatformAccess.getAccess().openGui((ServerPlayer)player, this.getScreenHandler(entity));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.getName()}), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected abstract GeneralScreenHandler<?> getScreenHandler(QpEntity var1);
}

