/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.PickIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

abstract sealed class AdvQuarryTarget
extends PickIterator<BlockPos> {
    protected final Area area;
    protected final BlockPos lastPos;
    protected final BlockPos.MutableBlockPos cursor;

    AdvQuarryTarget(Area area, BlockPos lastPos) {
        this.area = area;
        this.lastPos = lastPos;
        this.cursor = new BlockPos.MutableBlockPos();
    }

    @Override
    public boolean hasNext() {
        return !this.lastPos.equals(this.lastReturned);
    }

    @Override
    public void setLastReturned(BlockPos lastReturned) {
        super.setLastReturned(lastReturned);
        if (lastReturned != null) {
            this.cursor.set((Vec3i)lastReturned);
        }
    }

    static BlockPos getFirstPos(Area area, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.UP, Direction.DOWN -> new BlockPos(area.maxX() - 1, area.minY(), area.minZ() + 1);
            case Direction.SOUTH -> new BlockPos(area.minX() + 1, area.minY(), area.maxZ() - 1);
            case Direction.EAST -> new BlockPos(area.maxX() - 1, area.minY(), area.maxZ() - 1);
            case Direction.WEST -> new BlockPos(area.minX() + 1, area.minY(), area.minZ() + 1);
        };
    }

    static BlockPos getLastPos(Area area, Direction direction) {
        return AdvQuarryTarget.getFirstPos(area, direction.getOpposite());
    }

    static final class ChunkByChunk
    extends AdvQuarryTarget {
        ChunkByChunk(Area area) {
            super(area, new BlockPos(area.maxX() - 1, area.minY(), area.maxZ() - 1));
        }

        @Override
        protected BlockPos update() {
            if (this.lastReturned == null) {
                this.cursor.set(this.area.minX() + 1, this.area.minY(), this.area.minZ() + 1);
                return this.cursor;
            }
            int currentChunkX = ChunkByChunk.blockToSectionCoordinate(((BlockPos)this.lastReturned).getX());
            int currentChunkZ = ChunkByChunk.blockToSectionCoordinate(((BlockPos)this.lastReturned).getZ());
            int maxX = this.area.maxX() - 1;
            int maxZ = this.area.maxZ() - 1;
            int minX = this.area.minX() + 1;
            int minZ = this.area.minZ() + 1;
            if (((BlockPos)this.lastReturned).getX() + 1 <= Math.min(ChunkByChunk.chunkToBlock(currentChunkX, 15), maxX)) {
                this.cursor.set(((BlockPos)this.lastReturned).getX() + 1, this.cursor.getY(), ((BlockPos)this.lastReturned).getZ());
                return this.cursor;
            }
            if (((BlockPos)this.lastReturned).getZ() + 1 <= Math.min(ChunkByChunk.chunkToBlock(currentChunkZ, 15), maxZ)) {
                this.cursor.set(Math.max(ChunkByChunk.chunkToBlock(currentChunkX, 0), minX), this.cursor.getY(), ((BlockPos)this.lastReturned).getZ() + 1);
                return this.cursor;
            }
            if (currentChunkX + 1 <= ChunkByChunk.blockToSectionCoordinate(maxX)) {
                this.cursor.set(Math.max(ChunkByChunk.chunkToBlock(currentChunkX + 1, 0), minX), this.cursor.getY(), Math.max(ChunkByChunk.chunkToBlock(currentChunkZ, 0), minZ));
                return this.cursor;
            }
            if (currentChunkZ + 1 <= ChunkByChunk.blockToSectionCoordinate(maxZ)) {
                this.cursor.set(Math.max(ChunkByChunk.chunkToBlock(ChunkByChunk.blockToSectionCoordinate(minX), 0), minX), this.cursor.getY(), Math.max(ChunkByChunk.chunkToBlock(currentChunkZ + 1, 0), minZ));
                return this.cursor;
            }
            this.cursor.set(((BlockPos)this.lastReturned).getX() + 1, this.cursor.getY(), ((BlockPos)this.lastReturned).getZ());
            return this.cursor;
        }

        private static int blockToSectionCoordinate(int absolutePos) {
            return absolutePos >> 4;
        }

        private static int chunkToBlock(int chunk, int block) {
            return (chunk << 4) + block;
        }
    }

    static final class North
    extends AdvQuarryTarget {
        North(Area area) {
            super(area, North.getLastPos(area, Direction.NORTH));
        }

        @Override
        protected BlockPos update() {
            if (this.lastReturned == null) {
                this.cursor.set((Vec3i)North.getFirstPos(this.area, Direction.NORTH));
                return this.cursor;
            }
            if (((BlockPos)this.lastReturned).getZ() + 1 < this.area.maxZ()) {
                this.cursor.setZ(((BlockPos)this.lastReturned).getZ() + 1);
            } else {
                this.cursor.set(((BlockPos)this.lastReturned).getX() - 1, ((BlockPos)this.lastReturned).getY(), this.area.minZ() + 1);
            }
            return this.cursor;
        }
    }
}

