/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public abstract class PickIterator<T>
implements Iterator<T> {
    protected T lastReturned = null;

    protected abstract T update();

    @Override
    public final T next() {
        this.lastReturned = this.update();
        return this.lastReturned;
    }

    @Nullable
    public T getLastReturned() {
        return this.lastReturned;
    }

    public void setLastReturned(T lastReturned) {
        this.lastReturned = lastReturned;
    }

    public static <T> PickIterator<T> empty() {
        return Empty.INSTANCE;
    }

    static final class Empty<T>
    extends PickIterator<T> {
        private static final Empty<Object> INSTANCE = new Empty();

        Empty() {
        }

        @Override
        protected T update() {
            throw new NoSuchElementException("No element in empty iterator");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void setLastReturned(T lastReturned) {
        }

        @Override
        public T getLastReturned() {
            return null;
        }
    }

    public static final class Single<T>
    extends PickIterator<T> {
        private final T value;

        public Single(T value) {
            this.value = value;
        }

        @Override
        protected T update() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in single iterator");
            }
            return this.value;
        }

        @Override
        public boolean hasNext() {
            return this.getLastReturned() == null;
        }
    }
}

