/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.enchantment.QuarryPickaxeEnchantment;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public final class EnchantmentCache {
    ItemEnchantments target;
    Object2IntMap<ResourceKey<Enchantment>> cache = new Object2IntOpenHashMap();
    ItemEnchantments enchantmentsForPickaxe;

    private void clear() {
        this.cache.clear();
        this.enchantmentsForPickaxe = null;
    }

    public int getLevel(ItemEnchantments enchantments, ResourceKey<Enchantment> enchantment, HolderGetter.Provider lookup) {
        if (this.target != enchantments) {
            this.target = enchantments;
            this.clear();
        }
        return this.cache.computeIfAbsent(enchantment, key -> {
            Optional e = lookup.lookup(Registries.ENCHANTMENT).flatMap(g -> g.get(enchantment));
            if (e.isEmpty()) {
                return 0;
            }
            return enchantments.getLevel((Holder)e.get());
        });
    }

    public ItemEnchantments getEnchantmentsForPickaxe(ItemEnchantments enchantments, HolderGetter.Provider lookup) {
        if (this.target != enchantments) {
            this.target = enchantments;
            this.clear();
        }
        if (this.enchantmentsForPickaxe == null) {
            ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(enchantments);
            builder.set((Holder)lookup.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(QuarryPickaxeEnchantment.KEY), 1);
            this.enchantmentsForPickaxe = builder.toImmutable();
        }
        return this.enchantmentsForPickaxe;
    }

    public String toString() {
        return "EnchantmentCache{enchantment=" + String.valueOf(this.target) + "}";
    }
}

