/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.wits.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class WITSCommand {
    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        String commandString = "wits";
        String opCommandString = "witsop";
        String dimensionArg = "dimension";
        String locationArg = "location";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandString).requires(permission -> permission.hasPermission(0))).executes(cs -> {
            WorldCoordinates coordinates;
            if (((CommandSourceStack)cs.getSource()).isPlayer()) {
                BlockPos currentPosition = ((CommandSourceStack)cs.getSource()).getPlayer().blockPosition();
                coordinates = WorldCoordinates.absolute((double)currentPosition.getX(), (double)currentPosition.getY(), (double)currentPosition.getZ());
            } else {
                coordinates = WorldCoordinates.absolute((double)0.0, (double)0.0, (double)0.0);
            }
            WITSCommand.listStructuresAtSpot(((CommandSourceStack)cs.getSource()).getLevel(), (Coordinates)coordinates, true, (CommandContext<CommandSourceStack>)cs);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)commandString).redirect((CommandNode)source));
        LiteralCommandNode source2 = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)opCommandString).requires(permission -> permission.hasPermission(2))).then(Commands.argument((String)dimensionArg, (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)locationArg, (ArgumentType)Vec3Argument.vec3()).executes(cs -> {
            WITSCommand.listStructuresAtSpot(DimensionArgument.getDimension((CommandContext)cs, (String)dimensionArg), Vec3Argument.getCoordinates((CommandContext)cs, (String)locationArg), false, (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)opCommandString).redirect((CommandNode)source2));
    }

    private static void listStructuresAtSpot(ServerLevel level, Coordinates coordinates, boolean callerPosition, CommandContext<CommandSourceStack> cs) {
        BlockPos centerPos = coordinates.getBlockPos((CommandSourceStack)cs.getSource());
        List structureStarts = level.structureManager().startsForStructure(new ChunkPos(centerPos), s -> true);
        List<Structure> structures = structureStarts.stream().filter(ss -> ss.getBoundingBox().isInside((Vec3i)centerPos)).map(StructureStart::getStructure).toList();
        if (structures.isEmpty()) {
            MutableComponent component = Component.literal((String)(callerPosition ? "There's no structures at your location." : "There's no structures at the location."));
            ((CommandSourceStack)cs.getSource()).sendSuccess(() -> WITSCommand.lambda$listStructuresAtSpot$6((Component)component), !((CommandSourceStack)cs.getSource()).isPlayer());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (callerPosition) {
            stringBuilder.append("Structure(s) at your location:");
        } else {
            stringBuilder.append("Structure(s) at ").append(centerPos).append(":");
        }
        for (Structure structure : structures) {
            ResourceLocation key = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)structure);
            stringBuilder.append("\u00a7r\n - \u00a76").append(key);
        }
        MutableComponent component = Component.literal((String)stringBuilder.toString());
        ((CommandSourceStack)cs.getSource()).sendSuccess(() -> WITSCommand.lambda$listStructuresAtSpot$7((Component)component), !((CommandSourceStack)cs.getSource()).isPlayer());
    }

    private static /* synthetic */ Component lambda$listStructuresAtSpot$7(Component component) {
        return component;
    }

    private static /* synthetic */ Component lambda$listStructuresAtSpot$6(Component component) {
        return component;
    }
}

