/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.EntityBlocker;
import net.xalcon.torchmaster.logic.EntityBlockerSerializerRegistry;

public class EntityBlockingManager
extends SavedData {
    private final Map<String, EntityBlocker> entityBlockers = new HashMap<String, EntityBlocker>();
    public static final SavedData.Factory<EntityBlockingManager> Factory = new SavedData.Factory(EntityBlockingManager::new, EntityBlockingManager::load, null);

    public void registerBlocker(EntityBlocker blocker) {
        this.entityBlockers.putIfAbsent(blocker.getIdentifier(), blocker);
        this.setDirty();
    }

    public void unregisterBlocker(EntityBlocker blocker) {
        this.entityBlockers.remove(blocker.getIdentifier());
        this.setDirty();
    }

    public boolean shouldBlockEntitySpawn(Entity entity, Level level, MobSpawnType spawnType) {
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            if (!blocker.shouldBlockEntitySpawn(entity, level, spawnType)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldBlockVillageSiege(Level level, BlockPos pos) {
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            if (!blocker.shouldBlockVillageSiege(level, pos)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldBlockVillageRaid(Level level, BlockPos pos) {
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            if (!blocker.shouldBlockVillageRaid(level, pos)) continue;
            return true;
        }
        return false;
    }

    public CompoundTag save() {
        ListTag list = new ListTag();
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            CompoundTag tag = EntityBlockerSerializerRegistry.Serialize(blocker);
            if (tag == null) {
                Torchmaster.LOG.error("Unable to save entity blocker {}, data is lost", (Object)blocker);
                continue;
            }
            list.add((Object)tag);
        }
        CompoundTag tag = new CompoundTag();
        tag.put("blockers", (Tag)list);
        return tag;
    }

    public void loadFrom(CompoundTag tag) {
        this.entityBlockers.clear();
        ListTag list = tag.getList("blockers", 10);
        for (int i = 0; i < list.size(); ++i) {
            EntityBlocker blocker = EntityBlockerSerializerRegistry.Deserialize(list.getCompound(i));
            if (blocker == null) {
                Torchmaster.LOG.error("Unable to load entity blocker from nbt, data is lost");
                continue;
            }
            this.entityBlockers.put(blocker.getIdentifier(), blocker);
        }
        this.setDirty();
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.put("registry", (Tag)this.save());
        return compoundTag;
    }

    public static EntityBlockingManager load(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag registryTag = tag.getCompound("registry");
        EntityBlockingManager mgr = new EntityBlockingManager();
        mgr.loadFrom(registryTag);
        return mgr;
    }
}

