/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.codec.MoreStreamCodecs;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class MouseEventServerMessage
extends ComputerServerMessage {
    public static final StreamCodec<RegistryFriendlyByteBuf, MouseEventServerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ComputerServerMessage::containerId, MoreStreamCodecs.ofEnum(Action.class), x -> x.action, (StreamCodec)ByteBufCodecs.VAR_INT, x -> x.arg, (StreamCodec)ByteBufCodecs.VAR_INT, x -> x.x, (StreamCodec)ByteBufCodecs.VAR_INT, x -> x.y, MouseEventServerMessage::new);
    private final Action action;
    private final int arg;
    private final int x;
    private final int y;

    public MouseEventServerMessage(AbstractContainerMenu menu, Action action, int arg, int x, int y) {
        this(menu.containerId, action, arg, x, y);
    }

    private MouseEventServerMessage(int id, Action action, int arg, int x, int y) {
        super(id);
        this.action = action;
        this.x = x;
        this.y = y;
        this.arg = arg;
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        ServerInputHandler input = container.getInput();
        switch (this.action.ordinal()) {
            case 0: {
                input.mouseClick(this.arg, this.x, this.y);
                break;
            }
            case 1: {
                input.mouseDrag(this.arg, this.x, this.y);
                break;
            }
            case 2: {
                input.mouseUp(this.arg, this.x, this.y);
                break;
            }
            case 3: {
                input.mouseScroll(this.arg, this.x, this.y);
            }
        }
    }

    public CustomPacketPayload.Type<MouseEventServerMessage> type() {
        return NetworkMessages.MOUSE_EVENT;
    }

    public static enum Action {
        CLICK,
        DRAG,
        UP,
        SCROLL;

    }
}

