/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.details;

import com.mojang.serialization.DynamicOps;
import dan200.computercraft.shared.details.DetailHelpers;
import dan200.computercraft.shared.util.NBTUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jspecify.annotations.Nullable;

public class ItemDetails {
    public static void fillBasic(Map<? super String, Object> data, ItemStack stack) {
        String hash;
        data.put("name", DetailHelpers.getId(BuiltInRegistries.ITEM, stack.getItem()));
        data.put("count", stack.getCount());
        DataComponentPatch components = stack.getComponentsPatch();
        String string = hash = components.isEmpty() ? null : NBTUtil.getNBTHash(DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)components).result().orElse(null));
        if (hash != null) {
            data.put("nbt", hash);
        }
    }

    public static void fill(Map<? super String, Object> data, ItemStack stack) {
        Unbreakable unbreakable;
        List<Map<String, Object>> enchants;
        data.put("displayName", stack.getHoverName().getString());
        data.put("maxCount", stack.getMaxStackSize());
        if (stack.isDamageableItem()) {
            data.put("damage", stack.getDamageValue());
            data.put("maxDamage", stack.getMaxDamage());
        }
        if (stack.getItem().isBarVisible(stack)) {
            data.put("durability", (double)stack.getItem().getBarWidth(stack) / 13.0);
        }
        data.put("tags", DetailHelpers.getTags(stack.getTags()));
        data.put("itemGroups", ItemDetails.getItemGroups(stack));
        ItemLore lore = (ItemLore)stack.get(DataComponents.LORE);
        if (lore != null && !lore.lines().isEmpty()) {
            data.put("lore", lore.lines().stream().map(Component::getString).toList());
        }
        if (!(enchants = ItemDetails.getAllEnchants(stack)).isEmpty()) {
            data.put("enchantments", enchants);
        }
        if ((unbreakable = (Unbreakable)stack.get(DataComponents.UNBREAKABLE)) != null && unbreakable.showInTooltip()) {
            data.put("unbreakable", true);
        }
    }

    private static List<Map<String, Object>> getItemGroups(ItemStack stack) {
        return CreativeModeTabs.allTabs().stream().filter(x -> x.shouldDisplay() && x.getType() == CreativeModeTab.Type.CATEGORY && x.contains(stack)).map(group -> {
            HashMap<String, String> groupData = new HashMap<String, String>(2);
            ResourceLocation id = BuiltInRegistries.CREATIVE_MODE_TAB.getKey(group);
            if (id != null) {
                groupData.put("id", id.toString());
            }
            groupData.put("displayName", group.getDisplayName().getString());
            return groupData;
        }).toList();
    }

    private static List<Map<String, Object>> getAllEnchants(ItemStack stack) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        ItemDetails.addEnchantments((ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS), enchants);
        ItemDetails.addEnchantments((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS), enchants);
        return enchants;
    }

    private static void addEnchantments(@Nullable ItemEnchantments rawEnchants, ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants == null || rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Object2IntMap.Entry entry : rawEnchants.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            int level = entry.getIntValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", enchantment.getRegisteredName());
            enchant.put("level", level);
            enchant.put("displayName", Enchantment.getFullname((Holder)enchantment, (int)level).getString());
            enchants.add(enchant);
        }
    }
}

