/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ExtraModels(List<ResourceLocation> models) {
    private static final Logger LOG = LoggerFactory.getLogger(ExtraModels.class);
    private static final Gson GSON = new Gson();
    public static final ResourceLocation PATH = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"extra_models.json");
    public static final Codec<ExtraModels> CODEC = ResourceLocation.CODEC.listOf().xmap(ExtraModels::new, ExtraModels::models);

    public static Collection<ResourceLocation> loadAll(ResourceManager resources) {
        HashSet<ResourceLocation> out = new HashSet<ResourceLocation>();
        for (Resource path : resources.getResourceStack(PATH)) {
            ExtraModels models;
            try (BufferedReader stream = path.openAsReader();){
                models = (ExtraModels)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)stream, JsonElement.class))).getOrThrow(JsonParseException::new);
            }
            catch (IOException | RuntimeException e) {
                LOG.error("Failed to load extra models from {}", (Object)path.sourcePackId());
                continue;
            }
            out.addAll(models.models());
        }
        return Collections.unmodifiableCollection(out);
    }
}

