/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.emi.recipe;

import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public abstract class CustomEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> ingredients;
    private final EmiRecipeCategory category;
    private final List<EmiStack> output;

    protected CustomEmiRecipe(ResourceLocation id, EmiRecipeCategory category, List<EmiIngredient> ingredients, List<EmiStack> output) {
        this.id = id;
        this.ingredients = ingredients;
        this.category = category;
        this.output = output;
    }

    public static List<EmiIngredient> combineIng(List<EmiIngredient> ... inputs) {
        return Arrays.stream(inputs).flatMap(Collection::stream).toList();
    }

    public static List<EmiIngredient> combineIng(List<EmiIngredient> inputs, EmiIngredient otherInput) {
        ArrayList<EmiIngredient> result = new ArrayList<EmiIngredient>(inputs);
        result.add(otherInput);
        return result;
    }

    public static List<EmiStack> combineStack(List<EmiStack> ... inputs) {
        return Arrays.stream(inputs).flatMap(Collection::stream).toList();
    }

    public static List<EmiIngredient> fromInput(List<Ingredient> ingredients) {
        return ingredients.stream().map(EmiIngredient::of).toList();
    }

    public static List<EmiIngredient> fromInput(EmiIngredient ingredients) {
        return List.of(ingredients);
    }

    public static List<EmiIngredient> fromInput(FluidStack fluidStack) {
        return CustomEmiRecipe.fromInput(EmiIngredient.of(Collections.singletonList(NeoForgeEmiStack.of((FluidStack)fluidStack))));
    }

    public static EmiIngredient fromInput(SizedFluidIngredient fluidStack) {
        return EmiIngredient.of(Arrays.stream(fluidStack.getFluids()).map(NeoForgeEmiStack::of).toList());
    }

    public static List<EmiStack> fromOutput(ItemStack output, FluidStack fluidStack) {
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        list.add(EmiStack.of((ItemStack)output));
        list.add(EmiStack.of((Fluid)fluidStack.getFluid(), (DataComponentPatch)fluidStack.getComponentsPatch(), (long)fluidStack.getAmount()));
        return list;
    }

    public static List<EmiStack> fromOutput(EmiStack output) {
        return List.of(output);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.ingredients;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }
}

