/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon;

import com.buuz135.industrial.item.addon.AddonItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class RangeAddonItem
extends AddonItem
implements ISpecialCreativeTabItem {
    private static Item[] MATERIALS = new Item[]{Items.COBBLESTONE, Items.LAPIS_LAZULI, Items.BONE_MEAL, Items.IRON_NUGGET, Items.COPPER_INGOT, Items.GOLD_NUGGET, Items.IRON_INGOT, Items.GOLD_INGOT, Items.QUARTZ, Items.DIAMOND, Items.POPPED_CHORUS_FRUIT, Items.EMERALD};
    public static final IAugmentType RANGE = () -> "Range";
    private int tier;

    public RangeAddonItem(int tier, TitaniumTab group) {
        super("range_addon_tier_" + tier, group, new Item.Properties().stacksTo(16));
        this.tier = tier;
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)RANGE, (float)this.tier);
    }

    public String getDescriptionId() {
        return Component.translatable((String)"item.industrialforegoing.addon").getString() + Component.translatable((String)"item.industrialforegoing.range_addon").getString() + Component.translatable((String)"item.industrialforegoing.tier").getString() + (this.tier + 1) + " ";
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"text.industrialforegoing.extra_range").getString() + "+" + (this.tier + 1))));
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void registerRecipe(RecipeOutput consumer) {
        DissolutionChamberRecipe.createRecipe(consumer, "range_addon_tier_" + this.tier, new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.REDSTONE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.REDSTONE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLASS_PANE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLASS_PANE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)MATERIALS[this.tier])}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)MATERIALS[this.tier])}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)MATERIALS[this.tier])}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)MATERIALS[this.tier])})), new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1000), 200, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        ItemStack stack = new ItemStack((ItemLike)this);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)RANGE, (float)this.tier);
        event.accept(stack);
    }
}

