/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.transporter;

import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.tuple.Pair;

public class ContainerTransporter
extends AbstractContainerMenu {
    public static DeferredHolder<MenuType<?>, MenuType<?>> TYPE;
    private final TransporterTile transporterTile;
    private Direction facing;

    public ContainerTransporter(int id, Inventory player, FriendlyByteBuf buffer) {
        this(id, (TransporterTile)player.player.getCommandSenderWorld().getBlockEntity(buffer.readBlockPos()), (Direction)buffer.readEnum(Direction.class), player);
    }

    public ContainerTransporter(int id, TransporterTile conveyor, Direction facing, Inventory player) {
        super((MenuType)TYPE.get(), id);
        this.transporterTile = conveyor;
        this.facing = facing;
        if (!conveyor.hasUpgrade(facing) && conveyor.getTransporterTypeMap().size() > 0) {
            this.facing = conveyor.getTransporterTypeMap().keySet().iterator().next();
        }
        this.createPlayerInventory(player);
    }

    private void createPlayerInventory(Inventory player) {
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)player, k, 8 + k * 18, 142));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        SidedInventoryComponent<TransporterTile> augment = this.transporterTile.getAugmentInventory();
        for (int i = 0; i < augment.getSlots(); ++i) {
            this.addSlot((Slot)new SlotItemHandler(augment, i, augment.getXPos() + (Integer)((Pair)augment.getSlotPosition().apply(i)).getLeft(), augment.getYPos() + (Integer)((Pair)augment.getSlotPosition().apply(i)).getRight()));
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public TransporterTile getTransporterTile() {
        return this.transporterTile;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }
}

