/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FrostyGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "frosty";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, integer) -> (Integer)this.calculate((ItemStack)stack).getLeft() > 0);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0;
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0) {
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).copy();
            ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).shrink(1);
            return this.calculate(stack);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.LIGHT_BLUE};
    }

    @Override
    public Item getDisplay() {
        return Items.SNOWBALL;
    }

    @Override
    public int getSlotSize() {
        return 64;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes(RegistryAccess registryAccess) {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Item item : new Item[]{Items.ICE, Items.PACKED_ICE, Items.SNOWBALL, Items.SNOW_BLOCK, Items.SNOW, Items.BLUE_ICE}) {
            ItemStack stack = new ItemStack((ItemLike)item);
            Pair<Integer, Integer> power = this.calculate(stack);
            recipes.add(new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.of((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
        }
        return recipes;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        if (stack.getItem() == Items.ICE) {
            return Pair.of((Object)400, (Object)40);
        }
        if (stack.getItem() == Items.PACKED_ICE) {
            return Pair.of((Object)400, (Object)40);
        }
        if (stack.getItem() == Items.BLUE_ICE) {
            return Pair.of((Object)3600, (Object)40);
        }
        if (stack.getItem() == Items.SNOWBALL) {
            return Pair.of((Object)400, (Object)5);
        }
        if (stack.getItem() == Items.SNOW_BLOCK) {
            return Pair.of((Object)400, (Object)20);
        }
        if (stack.getItem() == Items.SNOW) {
            return Pair.of((Object)500, (Object)2);
        }
        return Pair.of((Object)0, (Object)160);
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.define(Character.valueOf('B'), (ItemLike)Items.SNOWBALL).define(Character.valueOf('C'), (ItemLike)Blocks.ICE).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_SIMPLE);
        return recipeBuilder;
    }

    @Override
    public void onTick(Level world, BlockPos pos) {
        AABB area = new AABB((double)(pos.getX() - 3), (double)(pos.getY() - 3), (double)(pos.getZ() - 3), (double)(pos.getX() + 3), (double)(pos.getY() + 3), (double)(pos.getZ() + 3));
        for (LivingEntity livingEntity : world.getEntitiesOfClass(LivingEntity.class, area)) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, 4));
        }
    }
}

