/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.PlantSowerConfig;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.mixin.IBushBlockMixin;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.bundle.LockableInventoryBundle;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import com.hrznstudio.titanium.item.AugmentWrapper;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.SpecialPlantable;

public class PlantSowerTile
extends IndustrialAreaWorkingTile<PlantSowerTile> {
    public static DyeColor[] COLORS = new DyeColor[]{DyeColor.RED, DyeColor.YELLOW, DyeColor.LIME, DyeColor.CYAN, DyeColor.WHITE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.BLACK};
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private ItemStackFilter filter = new ItemStackFilter("filter", 9){

        public void onContentChanged() {
            super.onContentChanged();
            PlantSowerTile.this.markForUpdate();
        }
    };
    @Save
    private LockableInventoryBundle<PlantSowerTile> input;

    public PlantSowerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.PLANT_SOWER, RangeManager.RangeType.TOP_UP, true, PlantSowerConfig.powerPerOperation, blockPos, blockState);
        this.addFilter((IFilter)this.filter);
        int pos = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                FilterSlot slot = new FilterSlot(45 + x * 18, 21 + y * 18, pos, (Object)ItemStack.EMPTY);
                slot.setColor(COLORS[pos]);
                this.filter.setFilter(pos, slot);
                ++pos;
            }
        }
        this.input = new LockableInventoryBundle((BasicTile)this, new SidedInventoryComponent("input", 108, 22, 9, 0).setColor(DyeColor.CYAN).setInputFilter((itemStack, integer) -> {
            BlockItem blockItem;
            Item patt0$temp;
            return itemStack.getItem() instanceof SpecialPlantable || (patt0$temp = itemStack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock() instanceof BushBlock;
        }).setRange(3, 3).setComponentHarness((IComponentHarness)this), 100, 84, false);
        this.addBundle((IComponentBundle)this.input);
        this.maxProgress = PlantSowerConfig.maxProgress;
        this.powerPerOperation = PlantSowerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pos = this.getPointedBlockPos();
        if (this.isLoaded(pos) && (this.level.isEmptyBlock(pos) || this.level.getBlockState(pos).is(Blocks.WATER)) && this.hasEnergy(this.powerPerOperation)) {
            SpecialPlantable specialPlantable;
            Item item;
            BushBlock bushBlock;
            BlockItem blockItem;
            Item item2;
            int slot = this.getFilteredSlot(pos);
            ItemStack stack = ItemStack.EMPTY;
            for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
                if (this.input.getInventory().getStackInSlot(i).isEmpty() || !((ItemStack)this.filter.getFilterSlots()[slot].getFilter()).isEmpty() && !ItemStack.isSameItem((ItemStack)((ItemStack)this.filter.getFilterSlots()[slot].getFilter()), (ItemStack)this.input.getInventory().getStackInSlot(i))) continue;
                stack = this.input.getInventory().getStackInSlot(i);
                break;
            }
            if (!stack.isEmpty() && (item2 = stack.getItem()) instanceof BlockItem && (item2 = (blockItem = (BlockItem)item2).getBlock()) instanceof BushBlock && ((IBushBlockMixin)(bushBlock = (BushBlock)item2)).invokeMayPlaceOn(this.level.getBlockState(pos.below()), (BlockGetter)this.level, pos.below())) {
                BlockState blockstate1 = blockItem.getBlock().defaultBlockState();
                this.level.setBlockAndUpdate(pos, blockstate1);
                stack.shrink(1);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 0.2f, this.powerPerOperation);
            }
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof SpecialPlantable && (specialPlantable = (SpecialPlantable)item).canPlacePlantAtPosition(stack, (LevelReader)this.level, pos.below(), Direction.UP)) {
                specialPlantable.spawnPlantAtPosition(stack, (LevelAccessor)this.level, pos.below(), Direction.UP);
                stack.shrink(1);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 0.2f, this.powerPerOperation);
            }
        }
        this.increasePointer();
        if (this.hasEnergy(this.powerPerOperation)) {
            return new IndustrialWorkingTile.WorkAction(this, 0.4f, this.powerPerOperation / 50);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private int getFilteredSlot(BlockPos pos) {
        int radius;
        int n = radius = this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0;
        if (radius == 0) {
            for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
                if (this.input.getInventory().getStackInSlot(i).isEmpty()) continue;
                return i;
            }
        }
        int x = Math.round(1.49f * (float)(pos.getX() - this.worldPosition.getX()) / (float)radius);
        int z = Math.round(1.49f * (float)(pos.getZ() - this.worldPosition.getZ()) / (float)radius);
        return 4 + x + 3 * z;
    }

    protected EnergyStorageComponent<PlantSowerTile> createEnergyStorage() {
        return new EnergyStorageComponent(PlantSowerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public PlantSowerTile getSelf() {
        return this;
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("PS_locked")) {
            this.input.setLocked(tag.getBoolean("PS_locked"));
        }
        if (tag.contains("PS_filter")) {
            for (String psFilter : tag.getCompound("PS_filter").getAllKeys()) {
                this.input.getFilter()[Integer.parseInt((String)psFilter)] = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("PS_filter").getCompound(psFilter));
            }
        }
        super.loadSettings(player, tag);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putBoolean("PS_locked", this.input.isLocked());
        CompoundTag filterTag = new CompoundTag();
        for (int i = 0; i < this.input.getFilter().length; ++i) {
            filterTag.put("" + i, this.input.getFilter()[i].saveOptional((HolderLookup.Provider)this.level.registryAccess()));
        }
        tag.put("PS_filter", (Tag)filterTag);
        super.saveSettings(player, tag);
    }
}

