/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.PlantFertilizerConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.ItemHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PlantFertilizerTile
extends IndustrialAreaWorkingTile<PlantFertilizerTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    public SidedInventoryComponent<PlantFertilizerTile> fertilizer = (SidedInventoryComponent)new SidedInventoryComponent("fertilizer", 50, 22, 18, 0).setColor(DyeColor.BROWN).setInputFilter((stack, integer) -> stack.is(IndustrialTags.Items.FERTILIZER)).setOutputFilter((stack, integer) -> false).setRange(6, 3).setComponentHarness((IComponentHarness)this);

    public PlantFertilizerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.PLANT_FERTILIZER, RangeManager.RangeType.BEHIND, true, PlantFertilizerConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.fertilizer);
        this.maxProgress = PlantFertilizerConfig.maxProgress;
        this.powerPerOperation = PlantFertilizerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockState state;
        Block block;
        BlockPos pointer;
        ItemStack stack = ItemHandlerUtil.getFirstItem(this.fertilizer);
        if (!stack.isEmpty() && this.hasEnergy(this.powerPerOperation) && this.isLoaded(pointer = this.getPointedBlockPos()) && (block = (state = this.level.getBlockState(pointer)).getBlock()) instanceof BonemealableBlock) {
            if (((BonemealableBlock)block).isValidBonemealTarget((LevelReader)this.level, pointer, state) && ((BonemealableBlock)block).isBonemealSuccess(this.level, this.level.random, pointer, state)) {
                stack.shrink(1);
                ((BonemealableBlock)block).performBonemeal((ServerLevel)this.level, this.level.random, pointer, state);
                if (((BonemealableBlock)block).isValidBonemealTarget((LevelReader)this.level, pointer, state)) {
                    return new IndustrialWorkingTile.WorkAction(this, 0.25f, this.powerPerOperation);
                }
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.powerPerOperation);
            }
            this.increasePointer();
            return new IndustrialWorkingTile.WorkAction(this, 0.5f, 0);
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<PlantFertilizerTile> createEnergyStorage() {
        return new EnergyStorageComponent(PlantFertilizerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public PlantFertilizerTile getSelf() {
        return this;
    }
}

