/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuardianCloudParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    private GuardianCloudParticle(ClientLevel p_i232414_1_, double x, double y, double z, double mx, double my, double mz, SpriteSet animatedSprite) {
        super(p_i232414_1_, x, y, z, 0.0, 0.0, 0.0);
        this.sprites = animatedSprite;
        float f = 2.5f;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += mx;
        this.yd += my;
        this.zd += mz;
        float f1 = 1.0f - (float)(Math.random() * (double)0.3f);
        if (mx == 0.0 && my == 0.0 && mz == 0.0) {
            this.rCol = 0.5f * f1;
            this.gCol = 0.0f;
            this.bCol = 1.0f * f1;
            this.scale(5.0f);
        } else {
            this.rCol = f1;
            this.gCol = f1;
            this.bCol = f1;
            this.scale(10.0f);
        }
        this.quadSize *= 1.875f;
        int i = (int)(8.0 / (Math.random() * 0.8 + 0.3));
        this.lifetime = (int)Math.max((float)i * 2.5f, 1.0f);
        this.hasPhysics = false;
        this.setSpriteFromAge(animatedSprite);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTicks) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            double d0;
            this.setSpriteFromAge(this.sprites);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.96f;
            this.yd *= (double)0.96f;
            this.zd *= (double)0.96f;
            Player playerentity = this.level.getNearestPlayer(this.x, this.y, this.z, 2.0, false);
            if (playerentity != null && this.y > (d0 = playerentity.getY())) {
                this.y += (d0 - this.y) * 0.2;
                this.yd += (playerentity.getDeltaMovement().y - this.yd) * 0.2;
                this.setPos(this.x, this.y, this.z);
            }
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet p_i50630_1_) {
            this.sprites = p_i50630_1_;
        }

        public Particle createParticle(SimpleParticleType p_199234_1_, ClientLevel p_199234_2_, double p_199234_3_, double p_199234_5_, double p_199234_7_, double p_199234_9_, double p_199234_11_, double p_199234_13_) {
            return new GuardianCloudParticle(p_199234_2_, p_199234_3_, p_199234_5_, p_199234_7_, p_199234_9_, p_199234_11_, p_199234_13_, this.sprites);
        }
    }
}

