/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.entity.GuardianCrystalRenderer;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DraconicGuardianRenderer
extends EntityRenderer<DraconicGuardianEntity> {
    public static final ResourceLocation ENDERCRYSTAL_BEAM_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/entity/guardian_crystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation GUARDIAN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/entity/chaos_guardian.png");
    private static final ResourceLocation EYES_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderdragon/dragon_eyes.png");
    private static final RenderType dragonCutoutType = RenderType.entityCutoutNoCull((ResourceLocation)GUARDIAN_TEXTURE);
    private static final RenderType dragonDeathType = RenderType.entityDecal((ResourceLocation)GUARDIAN_TEXTURE);
    private static final RenderType eyesType = RenderType.eyes((ResourceLocation)EYES_TEXTURE);
    private static final RenderType beamType = RenderType.entitySmoothCutout((ResourceLocation)ENDERCRYSTAL_BEAM_TEXTURES);
    private static RenderType BEAM_TYPE2 = RenderType.create((String)"beam_type_2", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderType.RENDERTYPE_ENTITY_SMOOTH_CUTOUT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENDERCRYSTAL_BEAM_TEXTURES, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    public static RenderType SHIELD_TYPE = RenderType.create((String)"draconicevolution:guardian_shield", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> DEShaders.shieldShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setCullState(RenderStateShard.NO_CULL).setDepthTestState(RenderStateShard.EQUAL_DEPTH_TEST).createCompositeState(false));
    private static final float sqrt3div2 = (float)(Math.sqrt(3.0) / 2.0);
    private final DragonModel model;

    public DraconicGuardianRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.model = new DragonModel(context.bakeLayer(ModelLayers.ENDER_DRAGON));
    }

    public void render(DraconicGuardianEntity guardian, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource getter, int packedLight) {
        ChargeUpPhase phase;
        IPhase iPhase;
        poseStack.pushPose();
        float f = (float)guardian.getLatencyPos(7, partialTicks)[0];
        float f1 = (float)(guardian.getLatencyPos(5, partialTicks)[1] - guardian.getLatencyPos(10, partialTicks)[1]);
        poseStack.mulPose(Axis.YP.rotationDegrees(-f));
        poseStack.mulPose(Axis.XP.rotationDegrees(f1 * 10.0f));
        poseStack.translate(0.0, 0.0, 1.0);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0, (double)-1.501f, 0.0);
        boolean flag = guardian.hurtTime > 0;
        this.model.prepareMobModel(guardian, 0.0f, 0.0f, partialTicks);
        if (guardian.deathTicks > 0) {
            float progress = (float)guardian.deathTicks / 200.0f;
            int fadeColour = FastColor.ARGB32.color((int)Mth.floor((float)(progress * 255.0f)), (int)-1);
            VertexConsumer builder = getter.getBuffer(RenderType.dragonExplosionAlpha((ResourceLocation)DRAGON_EXPLODING_TEXTURES));
            this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.NO_OVERLAY, fadeColour);
            builder = getter.getBuffer(dragonDeathType);
            this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.pack((float)0.0f, (boolean)flag));
        } else {
            VertexConsumer builder = getter.getBuffer(dragonCutoutType);
            this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.pack((float)0.0f, (boolean)flag));
        }
        boolean isImmune = guardian.getPhaseManager().getCurrentPhase().isInvulnerable();
        float shieldState = ((Float)guardian.getEntityData().get(DraconicGuardianEntity.SHIELD_POWER)).floatValue() / (float)DEConfig.guardianShield;
        if (shieldState > 0.0f || isImmune) {
            if (isImmune) {
                DEShaders.shieldColour.glUniform4f(0.0f, 1.0f, 1.0f, 2.0f);
            } else {
                DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 1.5f * shieldState);
            }
            DEShaders.shieldBarMode.glUniform1i(0);
            DEShaders.shieldActivation.glUniform1f(1.0f);
            VertexConsumer builder = getter.getBuffer(SHIELD_TYPE);
            this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.pack((float)0.0f, (boolean)flag));
        }
        VertexConsumer builder = getter.getBuffer(eyesType);
        this.model.renderToBuffer(poseStack, builder, packedLight, OverlayTexture.NO_OVERLAY);
        if (guardian.deathTicks > 0) {
            float f5 = ((float)guardian.deathTicks + partialTicks) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            Random random = new Random(432L);
            builder = getter.getBuffer(RenderType.lightning());
            poseStack.pushPose();
            poseStack.translate(0.0, -1.0, -2.0);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = poseStack.last().pose();
                int j = (int)(255.0f * (1.0f - f7));
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimB(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimC(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimC(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimD(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimD(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimB(builder, matrix4f, f3, f4);
                ++i;
            }
            poseStack.popPose();
        }
        poseStack.popPose();
        if (guardian.closestGuardianCrystal != null) {
            poseStack.pushPose();
            float relX = (float)(guardian.closestGuardianCrystal.getX() - Mth.lerp((double)partialTicks, (double)guardian.xo, (double)guardian.getX()));
            float relY = (float)(guardian.closestGuardianCrystal.getY() - Mth.lerp((double)partialTicks, (double)guardian.yo, (double)guardian.getY()));
            float relZ = (float)(guardian.closestGuardianCrystal.getZ() - Mth.lerp((double)partialTicks, (double)guardian.zo, (double)guardian.getZ()));
            DraconicGuardianRenderer.renderBeam(relX, relY + GuardianCrystalRenderer.getY(guardian.closestGuardianCrystal, partialTicks), relZ, partialTicks, guardian.tickCount, poseStack, getter, packedLight);
            poseStack.popPose();
        }
        if ((iPhase = guardian.getPhaseManager().getCurrentPhase()) instanceof ChargeUpPhase && guardian.getArenaOrigin() != null && (phase = (ChargeUpPhase)iPhase).animState() != 0.0f) {
            BlockPos origin = guardian.getArenaOrigin();
            float beamSin = Mth.sin((float)(phase.animState() * (float)Math.PI));
            poseStack.pushPose();
            float relX = (float)((double)origin.getX() + 0.5 - Mth.lerp((double)partialTicks, (double)guardian.xo, (double)guardian.getX()));
            float relY = (float)((double)origin.getY() + 0.5 - Mth.lerp((double)partialTicks, (double)guardian.yo, (double)guardian.getY()));
            float relZ = (float)((double)origin.getZ() + 0.5 - Mth.lerp((double)partialTicks, (double)guardian.zo, (double)guardian.getZ()));
            DraconicGuardianRenderer.renderChargingBeam(relX, relY, relZ, partialTicks, guardian.tickCount, poseStack, getter, packedLight, beamSin);
            poseStack.popPose();
        }
        super.render((Entity)guardian, entityYaw, partialTicks, poseStack, getter, packedLight);
    }

    private static void deathAnimA(VertexConsumer builder, Matrix4f mat, int alpha) {
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(255, 0, 0, alpha);
        builder.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(255, 0, 0, alpha);
    }

    private static void deathAnimB(VertexConsumer builder, Matrix4f mat, float p_229060_2_, float p_229060_3_) {
        builder.addVertex(mat, -sqrt3div2 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).setColor(255, 0, 0, 0);
    }

    private static void deathAnimC(VertexConsumer builder, Matrix4f mat, float p_229062_2_, float p_229062_3_) {
        builder.addVertex(mat, sqrt3div2 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).setColor(255, 0, 255, 0);
    }

    private static void deathAnimD(VertexConsumer builder, Matrix4f mat, float p_229063_2_, float p_229063_3_) {
        builder.addVertex(mat, 0.0f, p_229063_2_, 1.0f * p_229063_3_).setColor(255, 0, 0, 0);
    }

    public static void renderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight) {
        float xzDistance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.pushPose();
        mStack.translate(0.0, 2.0, 0.0);
        mStack.mulPose(Axis.YP.rotation((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.mulPose(Axis.XP.rotation((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.getBuffer(beamType);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose stackLast = mStack.last();
        Matrix4f lastMatrix = stackLast.pose();
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.sin((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = Mth.cos((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.addVertex(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).setColor(0, 0, 0, 255).setUv(f6, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, f4, f5, distance).setColor(255, 255, 255, 255).setUv(f6, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin, rCos, distance).setColor(255, 255, 255, 255).setUv(indexDecimal, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).setColor(0, 0, 0, 255).setUv(indexDecimal, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.popPose();
    }

    public static void renderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, float alpha) {
        float xzDistance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.pushPose();
        mStack.translate(0.0, 2.0, 0.0);
        mStack.mulPose(Axis.YP.rotation((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.mulPose(Axis.XP.rotation((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.getBuffer(BEAM_TYPE2);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose stackLast = mStack.last();
        Matrix4f lastMatrix = stackLast.pose();
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.sin((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = Mth.cos((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.addVertex(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(f6, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, f4, f5, distance).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(f6, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin, rCos, distance).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(indexDecimal, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(indexDecimal, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.popPose();
    }

    public static void renderChargingBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, float alpha) {
        float xzDistance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.pushPose();
        mStack.translate(0.0, 2.0, 0.0);
        mStack.mulPose(Axis.YP.rotation((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.mulPose(Axis.XP.rotation((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.getBuffer(BEAM_TYPE2);
        float vMin = ((float)animTicks + partialTicks) * 0.01f;
        float vMax = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f + ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.1f;
        float texU = 0.0f;
        PoseStack.Pose stackLast = mStack.last();
        Matrix4f lastMatrix = stackLast.pose();
        float taperOffset = 10.0f;
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.sin((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.1f;
            float rCos = Mth.cos((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.1f;
            float indexDecimal = (float)j / 8.0f;
            builder.addVertex(lastMatrix, f4 * taperOffset, f5 * taperOffset, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(texU, vMin).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, f4, f5, distance).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(texU, vMax).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin, rCos, distance).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(indexDecimal, vMax).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin * taperOffset, rCos * taperOffset, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(indexDecimal, vMin).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            f4 = rSin;
            f5 = rCos;
            texU = indexDecimal;
        }
        mStack.popPose();
    }

    public static void renderShaderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight) {
        float xzDistance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.pushPose();
        mStack.translate(0.0, 2.0, 0.0);
        mStack.mulPose(Axis.YP.rotation((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.mulPose(Axis.XP.rotation((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.getBuffer(beamType);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = Mth.sqrt((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose stackLast = mStack.last();
        Matrix4f lastMatrix = stackLast.pose();
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.sin((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = Mth.cos((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.addVertex(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).setColor(0, 0, 0, 255).setUv(f6, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, f4, f5, distance).setColor(255, 255, 255, 255).setUv(f6, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin, rCos, distance).setColor(255, 255, 255, 255).setUv(indexDecimal, f3).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            builder.addVertex(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).setColor(0, 0, 0, 255).setUv(indexDecimal, f2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(stackLast, 0.0f, -1.0f, 0.0f);
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.popPose();
    }

    public ResourceLocation getTextureLocation(DraconicGuardianEntity entity) {
        return DRAGON_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DragonModel
    extends EntityModel<DraconicGuardianEntity> {
        private final ModelPart head;
        private final ModelPart neck;
        private final ModelPart jaw;
        private final ModelPart body;
        private final ModelPart leftWing;
        private final ModelPart leftWingTip;
        private final ModelPart leftFrontLeg;
        private final ModelPart leftFrontLegTip;
        private final ModelPart leftFrontFoot;
        private final ModelPart leftRearLeg;
        private final ModelPart leftRearLegTip;
        private final ModelPart leftRearFoot;
        private final ModelPart rightWing;
        private final ModelPart rightWingTip;
        private final ModelPart rightFrontLeg;
        private final ModelPart rightFrontLegTip;
        private final ModelPart rightFrontFoot;
        private final ModelPart rightRearLeg;
        private final ModelPart rightRearLegTip;
        private final ModelPart rightRearFoot;
        @Nullable
        private DraconicGuardianEntity entity;
        private float a;

        public DragonModel(ModelPart modelPart) {
            this.head = modelPart.getChild("head");
            this.jaw = this.head.getChild("jaw");
            this.neck = modelPart.getChild("neck");
            this.body = modelPart.getChild("body");
            this.leftWing = modelPart.getChild("left_wing");
            this.leftWingTip = this.leftWing.getChild("left_wing_tip");
            this.leftFrontLeg = modelPart.getChild("left_front_leg");
            this.leftFrontLegTip = this.leftFrontLeg.getChild("left_front_leg_tip");
            this.leftFrontFoot = this.leftFrontLegTip.getChild("left_front_foot");
            this.leftRearLeg = modelPart.getChild("left_hind_leg");
            this.leftRearLegTip = this.leftRearLeg.getChild("left_hind_leg_tip");
            this.leftRearFoot = this.leftRearLegTip.getChild("left_hind_foot");
            this.rightWing = modelPart.getChild("right_wing");
            this.rightWingTip = this.rightWing.getChild("right_wing_tip");
            this.rightFrontLeg = modelPart.getChild("right_front_leg");
            this.rightFrontLegTip = this.rightFrontLeg.getChild("right_front_leg_tip");
            this.rightFrontFoot = this.rightFrontLegTip.getChild("right_front_foot");
            this.rightRearLeg = modelPart.getChild("right_hind_leg");
            this.rightRearLegTip = this.rightRearLeg.getChild("right_hind_leg_tip");
            this.rightRearFoot = this.rightRearLegTip.getChild("right_hind_foot");
        }

        public void prepareMobModel(DraconicGuardianEntity p_114269_, float p_114270_, float p_114271_, float p_114272_) {
            this.entity = p_114269_;
            this.a = p_114272_;
        }

        public void setupAnim(DraconicGuardianEntity p_114274_, float p_114275_, float p_114276_, float p_114277_, float p_114278_, float p_114279_) {
        }

        public void renderToBuffer(PoseStack p_114281_, VertexConsumer p_114282_, int p_114283_, int p_114284_, int colour) {
            p_114281_.pushPose();
            float f = Mth.lerp((float)this.a, (float)this.entity.oFlapTime, (float)this.entity.flapTime);
            this.jaw.xRot = (float)(Math.sin(f * ((float)Math.PI * 2)) + 1.0) * 0.2f;
            float f1 = (float)(Math.sin(f * ((float)Math.PI * 2) - 1.0f) + 1.0);
            f1 = (f1 * f1 + f1 * 2.0f) * 0.05f;
            p_114281_.translate(0.0, (double)(f1 - 2.0f), -3.0);
            p_114281_.mulPose(Axis.XP.rotationDegrees(f1 * 2.0f));
            float f2 = 0.0f;
            float f3 = 20.0f;
            float f4 = -12.0f;
            float f5 = 1.5f;
            double[] adouble = this.entity.getLatencyPos(6, this.a);
            float f6 = Mth.wrapDegrees((float)((float)this.entity.getLatencyPos(5, this.a)[0] - (float)this.entity.getLatencyPos(10, this.a)[0]));
            float f7 = Mth.wrapDegrees((float)((float)this.entity.getLatencyPos(5, this.a)[0] + f6 / 2.0f));
            float f8 = f * ((float)Math.PI * 2);
            for (int i = 0; i < 5; ++i) {
                double[] adouble1 = this.entity.getLatencyPos(5 - i, this.a);
                float f9 = (float)Math.cos((float)i * 0.45f + f8) * 0.15f;
                this.neck.yRot = Mth.wrapDegrees((float)((float)(adouble1[0] - adouble[0]))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.xRot = f9 + this.entity.getHeadPartYOffset(i, adouble, adouble1) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.neck.zRot = -Mth.wrapDegrees((float)((float)(adouble1[0] - (double)f7))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.y = f3;
                this.neck.z = f4;
                this.neck.x = f2;
                f3 += Mth.sin((float)this.neck.xRot) * 10.0f;
                f4 -= Mth.cos((float)this.neck.yRot) * Mth.cos((float)this.neck.xRot) * 10.0f;
                f2 -= Mth.sin((float)this.neck.yRot) * Mth.cos((float)this.neck.xRot) * 10.0f;
                this.neck.render(p_114281_, p_114282_, p_114283_, p_114284_, colour);
            }
            this.head.y = f3;
            this.head.z = f4;
            this.head.x = f2;
            double[] adouble2 = this.entity.getLatencyPos(0, this.a);
            this.head.yRot = Mth.wrapDegrees((float)((float)(adouble2[0] - adouble[0]))) * ((float)Math.PI / 180);
            this.head.xRot = Mth.wrapDegrees((float)this.entity.getHeadPartYOffset(6, adouble, adouble2)) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            this.head.zRot = -Mth.wrapDegrees((float)((float)(adouble2[0] - (double)f7))) * ((float)Math.PI / 180);
            this.head.render(p_114281_, p_114282_, p_114283_, p_114284_, colour);
            p_114281_.pushPose();
            p_114281_.translate(0.0, 1.0, 0.0);
            p_114281_.mulPose(Axis.ZP.rotationDegrees(-f6 * 1.5f));
            p_114281_.translate(0.0, -1.0, 0.0);
            this.body.zRot = 0.0f;
            this.body.render(p_114281_, p_114282_, p_114283_, p_114284_, colour);
            float f10 = f * ((float)Math.PI * 2);
            this.leftWing.xRot = 0.125f - (float)Math.cos(f10) * 0.2f;
            this.leftWing.yRot = -0.25f;
            this.leftWing.zRot = -((float)(Math.sin(f10) + 0.125)) * 0.8f;
            this.leftWingTip.zRot = (float)(Math.sin(f10 + 2.0f) + 0.5) * 0.75f;
            this.rightWing.xRot = this.leftWing.xRot;
            this.rightWing.yRot = -this.leftWing.yRot;
            this.rightWing.zRot = -this.leftWing.zRot;
            this.rightWingTip.zRot = -this.leftWingTip.zRot;
            this.renderSide(p_114281_, p_114282_, p_114283_, p_114284_, f1, this.leftWing, this.leftFrontLeg, this.leftFrontLegTip, this.leftFrontFoot, this.leftRearLeg, this.leftRearLegTip, this.leftRearFoot, colour);
            this.renderSide(p_114281_, p_114282_, p_114283_, p_114284_, f1, this.rightWing, this.rightFrontLeg, this.rightFrontLegTip, this.rightFrontFoot, this.rightRearLeg, this.rightRearLegTip, this.rightRearFoot, colour);
            p_114281_.popPose();
            float f11 = -Mth.sin((float)(f * ((float)Math.PI * 2))) * 0.0f;
            f8 = f * ((float)Math.PI * 2);
            f3 = 10.0f;
            f4 = 60.0f;
            f2 = 0.0f;
            adouble = this.entity.getLatencyPos(11, this.a);
            for (int j = 0; j < 12; ++j) {
                adouble2 = this.entity.getLatencyPos(12 + j, this.a);
                this.neck.yRot = (Mth.wrapDegrees((float)((float)(adouble2[0] - adouble[0]))) * 1.5f + 180.0f) * ((float)Math.PI / 180);
                this.neck.xRot = (f11 += Mth.sin((float)((float)j * 0.45f + f8)) * 0.05f) + (float)(adouble2[1] - adouble[1]) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.neck.zRot = Mth.wrapDegrees((float)((float)(adouble2[0] - (double)f7))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.y = f3;
                this.neck.z = f4;
                this.neck.x = f2;
                f3 += Mth.sin((float)this.neck.xRot) * 10.0f;
                f4 -= Mth.cos((float)this.neck.yRot) * Mth.cos((float)this.neck.xRot) * 10.0f;
                f2 -= Mth.sin((float)this.neck.yRot) * Mth.cos((float)this.neck.xRot) * 10.0f;
                this.neck.render(p_114281_, p_114282_, p_114283_, p_114284_, colour);
            }
            p_114281_.popPose();
        }

        private void renderSide(PoseStack p_173978_, VertexConsumer p_173979_, int p_173980_, int p_173981_, float p_173982_, ModelPart p_173983_, ModelPart p_173984_, ModelPart p_173985_, ModelPart p_173986_, ModelPart p_173987_, ModelPart p_173988_, ModelPart p_173989_, int colour) {
            p_173987_.xRot = 1.0f + p_173982_ * 0.1f;
            p_173988_.xRot = 0.5f + p_173982_ * 0.1f;
            p_173989_.xRot = 0.75f + p_173982_ * 0.1f;
            p_173984_.xRot = 1.3f + p_173982_ * 0.1f;
            p_173985_.xRot = -0.5f - p_173982_ * 0.1f;
            p_173986_.xRot = 0.75f + p_173982_ * 0.1f;
            p_173983_.render(p_173978_, p_173979_, p_173980_, p_173981_, colour);
            p_173984_.render(p_173978_, p_173979_, p_173980_, p_173981_, colour);
            p_173987_.render(p_173978_, p_173979_, p_173980_, p_173981_, colour);
        }
    }
}

