/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.keybinding;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindings {
    public static KeyMapping placeItem;
    public static KeyMapping toolConfig;
    public static KeyMapping toolModules;
    public static KeyMapping toggleFlight;
    public static KeyMapping toggleMagnet;
    public static KeyMapping dislocatorTeleport;
    public static KeyMapping dislocatorBlink;
    public static KeyMapping dislocatorGui;
    public static KeyMapping dislocatorUp;
    public static KeyMapping dislocatorDown;

    public static void init(IEventBus eventBus) {
        placeItem = new KeyMapping("key.draconicevolution.place_item", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> placeItem), InputConstants.Type.KEYSYM, 80, "Draconic Evolution");
        toolConfig = new KeyMapping("key.draconicevolution.tool_config", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> toolConfig), InputConstants.Type.KEYSYM, 67, "Draconic Evolution");
        toggleFlight = new KeyMapping("key.draconicevolution.toggle_flight", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> toggleFlight), InputConstants.Type.KEYSYM, -1, "Draconic Evolution");
        toggleMagnet = new KeyMapping("key.draconicevolution.toggle_magnet", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> toggleMagnet), InputConstants.Type.KEYSYM, -1, "Draconic Evolution");
        dislocatorTeleport = new KeyMapping("key.draconicevolution.dislocator_teleport", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> dislocatorTeleport), InputConstants.Type.KEYSYM, -1, "Draconic Evolution");
        dislocatorBlink = new KeyMapping("key.draconicevolution.dislocator_blink", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> dislocatorBlink), InputConstants.Type.KEYSYM, -1, "Draconic Evolution");
        dislocatorGui = new KeyMapping("key.draconicevolution.dislocator_gui", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> dislocatorGui), InputConstants.Type.KEYSYM, -1, "Draconic Evolution");
        dislocatorUp = new KeyMapping("key.draconicevolution.dislocator_up", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> dislocatorUp), InputConstants.Type.KEYSYM, -1, "Draconic Evolution");
        dislocatorDown = new KeyMapping("key.draconicevolution.dislocator_down", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> dislocatorDown), InputConstants.Type.KEYSYM, -1, "Draconic Evolution");
        toolModules = new KeyMapping("key.draconicevolution.tool_modules", (IKeyConflictContext)new CustomContext(KeyConflictContext.IN_GAME, () -> toolModules), KeyModifier.SHIFT, InputConstants.Type.KEYSYM, 67, "Draconic Evolution");
        eventBus.addListener(KeyBindings::registerKeyMappings);
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(placeItem);
        event.register(toolConfig);
        event.register(toolModules);
        event.register(toggleFlight);
        event.register(toggleMagnet);
        event.register(dislocatorTeleport);
        event.register(dislocatorBlink);
        event.register(dislocatorGui);
        event.register(dislocatorUp);
        event.register(dislocatorDown);
    }

    private static class CustomContext
    implements IKeyConflictContext {
        private KeyConflictContext context;
        private Supplier<KeyMapping> binding;

        public CustomContext(KeyConflictContext context, Supplier<KeyMapping> binding) {
            this.context = context;
            this.binding = binding;
        }

        public boolean isActive() {
            return this.context.isActive();
        }

        public boolean conflicts(IKeyConflictContext other) {
            if (!(other instanceof CustomContext)) {
                return other == this.context;
            }
            if (((CustomContext)other).context != this.context) {
                return false;
            }
            KeyMapping otherBind = ((CustomContext)other).binding.get();
            return otherBind.getKey().getValue() == this.binding.get().getKey().getValue() && otherBind.getKeyModifier() == this.binding.get().getKeyModifier();
        }
    }
}

