/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.particle.IntParticleData;
import com.brandon3055.brandonscore.inventory.ItemHandlerIOControl;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedFloat;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedResource;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.datamanager.ManagedTextComponent;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingInjector;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.tile.fxhandlers.ITileFXHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.FusionCraftingCoreMenu;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class TileFusionCraftingCore
extends TileBCore
implements IFusionInventory,
IFusionStateMachine,
MenuProvider,
IInteractTile,
IChangeListener {
    private final ManagedEnum<IFusionStateMachine.FusionState> fusionState = (ManagedEnum)this.register((IManagedData)new ManagedEnum("fusion_state", (Enum)IFusionStateMachine.FusionState.START, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedResource activeRecipe = (ManagedResource)this.register((IManagedData)new ManagedResource("active_recipe", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedBool crafting = (ManagedBool)this.register((IManagedData)new ManagedBool("is_crafting", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedInt fusionCounter = (ManagedInt)this.register((IManagedData)new ManagedInt("fusion_counter", new DataFlags[]{DataFlags.SAVE_NBT}));
    public final ManagedTextComponent userStatus = (ManagedTextComponent)this.register((IManagedData)new ManagedTextComponent("user_status", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedFloat craftAnimProgress = (ManagedFloat)this.register((IManagedData)new ManagedFloat("craft_anim_progress", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedShort craftAnimLength = (ManagedShort)this.register((IManagedData)new ManagedShort("craft_anim_length", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedFloat progress = (ManagedFloat)this.register((IManagedData)new ManagedFloat("progress", -1.0f, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, 2);
    public ITileFXHandler fxHandler;
    private List<IFusionInjector> injectorCache = null;
    private List<BlockPos> injectorPositions = new ArrayList<BlockPos>();
    private RecipeHolder<IFusionRecipe> recipeCache = null;
    private TechLevel minTierCache = null;

    public TileFusionCraftingCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_CRAFTING_CORE.get(), pos, state);
        this.capManager.setInternalManaged("inventory", Capabilities.ItemHandler.BLOCK, (INBTSerializable)this.itemHandler).saveBoth();
        this.capManager.set(Capabilities.ItemHandler.BLOCK, (Object)new ItemHandlerIOControl((IItemHandler)this.itemHandler).setInsertCheck((slot, stack) -> slot == 0).setExtractCheck((slot, stack) -> slot == 1), new Direction[0]);
        this.itemHandler.setContentsChangeListener(i -> this.localInventoryChange());
        this.itemHandler.setStackValidator((slot, stack) -> slot == 0);
        this.fxHandler = DraconicEvolution.proxy.createFusionFXHandler(this);
        this.activeRecipe.addValueListener(e -> {
            this.recipeCache = null;
        });
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileFusionCraftingCore.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_CRAFTING_CORE, (BlockCapability)Capabilities.ItemHandler.BLOCK);
    }

    public void startCraft() {
        if (this.isCrafting()) {
            this.inventoryChanged();
            return;
        }
        this.updateInjectors();
        RecipeHolder holder = this.level.getRecipeManager().getRecipeFor((RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get(), (RecipeInput)this, this.level).orElse(null);
        IFusionRecipe recipe = holder == null ? null : (IFusionRecipe)holder.value();
        this.setActiveRecipe((RecipeHolder<IFusionRecipe>)holder);
        if (recipe == null || !recipe.canStartCraft(this, this.level, null)) {
            return;
        }
        this.setCounter(0);
        this.setFusionState(IFusionStateMachine.FusionState.START);
        this.crafting.set(true);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        this.startCraft();
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 0) {
            this.injectorPositions.clear();
            int count = data.readShort();
            for (int i = 0; i < count; ++i) {
                this.injectorPositions.add(data.readPos());
            }
            this.injectorCache = null;
        } else if (id == 1) {
            this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, 1.0, 0.0, 0.0);
            this.level.playLocalSound((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
            for (int i = 0; i < 100; ++i) {
                double velX = (this.level.random.nextDouble() - 0.5) * 0.1;
                double velY = (this.level.random.nextDouble() - 0.5) * 0.1;
                double velZ = (this.level.random.nextDouble() - 0.5) * 0.1;
                this.level.addParticle((ParticleOptions)new IntParticleData((ParticleType)DEParticles.ENERGY_BASIC.get(), new Integer[]{0, 255, 255, 64}), (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, velX, velY, velZ);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.fxHandler.tick();
        }
        if (this.crafting.get() && !this.level.isClientSide) {
            RecipeHolder<IFusionRecipe> recipe = this.getActiveRecipe();
            if (recipe != null) {
                ((IFusionRecipe)recipe.value()).tickFusionState(this, this, this.level);
            } else {
                this.cancelCraft();
            }
        }
    }

    public boolean updateInjectors() {
        this.minTierCache = null;
        if (this.isCrafting() || this.level.isClientSide) {
            return true;
        }
        if (this.injectorPositions.isEmpty()) {
            this.setFusionStatus(-1.0, null);
        }
        this.injectorCache = null;
        ArrayList<BlockPos> oldPositions = new ArrayList<BlockPos>(this.injectorPositions);
        this.injectorPositions.clear();
        int range = DEConfig.fusionInjectorRange;
        int radius = 1;
        List searchTiles = Streams.concat((Stream[])new Stream[]{BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-range, -radius, -radius), (BlockPos)this.worldPosition.offset(range, radius, radius)), BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-radius, -range, -radius), (BlockPos)this.worldPosition.offset(radius, range, radius)), BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-radius, -radius, -range), (BlockPos)this.worldPosition.offset(radius, radius, range))}).map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).filter(e -> e instanceof TileFusionCraftingInjector).map(e -> (TileFusionCraftingInjector)e).collect(Collectors.toList());
        for (TileFusionCraftingInjector tile : searchTiles) {
            Vec3D dirVec = new Vec3D(tile.getBlockPos()).subtract(this.worldPosition);
            double dist = Utils.getCardinalDistance((BlockPos)tile.getBlockPos(), (BlockPos)this.worldPosition);
            if (dist <= (double)DEConfig.fusionInjectorMinDist) {
                this.setFusionStatus(-1.0, (Component)Component.translatable((String)"fusion_status.draconicevolution.injector_close").withStyle(ChatFormatting.RED));
                this.injectorPositions.clear();
                return false;
            }
            if (Direction.getNearest((float)((int)dirVec.x), (float)((int)dirVec.y), (float)((int)dirVec.z)) != tile.getRotation().getOpposite()) continue;
            BlockPos pos = tile.getBlockPos();
            Direction facing = tile.getRotation();
            boolean obstructed = false;
            for (BlockPos bp : BlockPos.betweenClosed((BlockPos)pos.relative(facing), (BlockPos)pos.relative(facing, FacingUtils.distanceInDirection((BlockPos)pos, (BlockPos)this.worldPosition, (Direction)facing) - 1))) {
                if (this.level.isEmptyBlock(bp) || !this.level.getBlockState(bp).canOcclude() && !(this.level.getBlockEntity(bp) instanceof TileFusionCraftingInjector)) continue;
                obstructed = true;
                tile.setCore(null);
                break;
            }
            if (obstructed || !tile.setCore(this)) continue;
            this.injectorPositions.add(tile.getBlockPos());
        }
        this.dirtyBlock();
        if (!oldPositions.equals(this.injectorPositions)) {
            this.sendPacketToChunk(e -> {
                e.writeShort(this.injectorPositions.size());
                this.injectorPositions.forEach(arg_0 -> ((MCDataOutput)e).writePos(arg_0));
            }, 0);
        }
        return true;
    }

    public void inventoryChanged() {
        this.setChanged();
        if (!this.updateInjectors()) {
            return;
        }
        if (this.isCrafting()) {
            RecipeHolder<IFusionRecipe> recipe = this.getActiveRecipe();
            if (recipe == null || !((IFusionRecipe)recipe.value()).matches(this, this.level)) {
                this.cancelCraft();
            }
        } else if (!this.level.isClientSide) {
            RecipeHolder recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get(), (RecipeInput)this, this.level).orElse(null);
            if (recipe != null) {
                ((IFusionRecipe)recipe.value()).canStartCraft(this, this.level, e -> this.setFusionStatus(-1.0, (Component)e));
            } else {
                this.setFusionStatus(-1.0, (Component)Component.translatable((String)"fusion_status.draconicevolution.no_recipe"));
            }
            this.setActiveRecipe((RecipeHolder<IFusionRecipe>)recipe);
        }
    }

    private void localInventoryChange() {
        this.updateBlock();
        this.inventoryChanged();
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            this.updateInjectors();
            player.openMenu((MenuProvider)this, this.worldPosition);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new FusionCraftingCoreMenu(currentWindowIndex, player.getInventory(), this);
    }

    @Override
    @Nonnull
    public ItemStack getCatalystStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Override
    @Nonnull
    public ItemStack getOutputStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    @Override
    public void setCatalystStack(@Nonnull ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    public void setOutputStack(@Nonnull ItemStack stack) {
        this.itemHandler.setStackInSlot(1, stack);
    }

    @Override
    public List<IFusionInjector> getInjectors() {
        if (this.injectorCache == null) {
            this.injectorCache = this.injectorPositions.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).filter(e -> e instanceof IFusionInjector).map(e -> (IFusionInjector)e).collect(Collectors.toList());
        }
        return this.injectorCache;
    }

    public ItemStack getItem(int index) {
        if (index <= 0) {
            return this.itemHandler.getStackInSlot(0);
        }
        List<IFusionInjector> injectors = this.getInjectors();
        return --index >= injectors.size() ? ItemStack.EMPTY : injectors.get(index).getInjectorStack();
    }

    public int size() {
        return this.getInjectors().size() + 1;
    }

    @Override
    public TechLevel getMinimumTier() {
        if (this.minTierCache == null) {
            this.minTierCache = this.getInjectors().stream().filter(e -> !e.getInjectorStack().isEmpty()).sorted(Comparator.comparing(e -> e.getInjectorTier().index)).map(IFusionInjector::getInjectorTier).findFirst().orElse(TechLevel.DRACONIUM);
        }
        return this.minTierCache;
    }

    public void onNeighborChange(BlockPos neighbor) {
        super.onNeighborChange(neighbor);
        this.updateInjectors();
    }

    @Override
    public IFusionStateMachine.FusionState getFusionState() {
        return (IFusionStateMachine.FusionState)this.fusionState.get();
    }

    @Override
    public void setFusionState(IFusionStateMachine.FusionState state) {
        this.fusionState.set((Enum)state);
        this.setChanged();
    }

    @Override
    public void completeCraft() {
        this.crafting.set(false);
        this.inventoryChanged();
        this.sendPacketToChunk(e -> {}, 1);
    }

    @Override
    public void cancelCraft() {
        this.crafting.set(false);
        this.getInjectors().forEach(e -> e.setEnergyRequirement(0L, 0L));
        this.setFusionStatus(-1.0, (Component)Component.translatable((String)"fusion_status.draconicevolution.canceled"));
        this.level.playSound(null, this.getBlockPos(), (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f);
        this.inventoryChanged();
    }

    @Override
    public int getCounter() {
        return this.fusionCounter.get();
    }

    @Override
    public void setCounter(int count) {
        this.fusionCounter.set(count);
    }

    @Override
    public void setFusionStatus(double progress, Component stateText) {
        this.progress.set((float)progress);
        this.userStatus.set(stateText);
    }

    @Override
    public void setCraftAnimation(float progress, int length) {
        this.craftAnimProgress.set(progress);
        this.craftAnimLength.set((short)length);
    }

    public boolean isCrafting() {
        return this.crafting.get();
    }

    @Nullable
    public RecipeHolder<IFusionRecipe> getActiveRecipe() {
        Recipe recipe;
        RecipeHolder recipe2;
        if (this.recipeCache == null && this.activeRecipe.get() != null && (recipe2 = (RecipeHolder)this.level.getRecipeManager().byKey(this.activeRecipe.get()).orElse(null)) != null && (recipe = recipe2.value()) instanceof IFusionRecipe) {
            IFusionRecipe fusionRecipe = (IFusionRecipe)recipe;
            this.recipeCache = recipe2;
        }
        return this.recipeCache;
    }

    public void setActiveRecipe(@Nullable RecipeHolder<IFusionRecipe> recipe) {
        this.recipeCache = recipe;
        this.activeRecipe.set(recipe == null ? null : recipe.id());
    }

    public int getComparatorOutput() {
        if (!this.getOutputStack().isEmpty()) {
            return 15;
        }
        if (this.crafting.get()) {
            return 1 + this.getFusionState().ordinal();
        }
        RecipeHolder recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get(), (RecipeInput)this, this.level).orElse(null);
        if (recipe != null && ((IFusionRecipe)recipe.value()).canStartCraft(this, this.level, null)) {
            return 1;
        }
        return 0;
    }

    public void writeExtraNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.writeExtraNBT(provider, compound);
        compound.putLongArray("injector_positions", this.injectorPositions.stream().mapToLong(BlockPos::asLong).toArray());
    }

    public void readExtraNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.readExtraNBT(provider, compound);
        this.injectorPositions = Arrays.stream(compound.getLongArray("injector_positions")).mapToObj(BlockPos::of).collect(Collectors.toList());
        this.injectorCache = null;
    }
}

