/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.blocks.ChaosCrystal;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class TileChaosCrystal
extends TileBCore {
    public int tick = 0;
    public final ManagedBool guardianDefeated = (ManagedBool)this.register((IManagedData)new ManagedBool("guardian_defeated", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedPos parentPos = (ManagedPos)this.register((IManagedData)new ManagedPos("parent_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedLong posLock = (ManagedLong)this.register((IManagedData)new ManagedLong("pos_lock", -1L, new DataFlags[]{DataFlags.SAVE_NBT}));
    private final ManagedString dimLock = (ManagedString)this.register((IManagedData)new ManagedString("dim_lock", "", new DataFlags[]{DataFlags.SAVE_NBT}));
    private boolean validatePlacement = false;
    private int soundTimer;
    private boolean removing = false;

    public TileChaosCrystal(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_CHAOS_CRYSTAL.get(), pos, state);
    }

    public void tick() {
        if (this.validatePlacement) {
            this.posLock.set(this.worldPosition.asLong());
            this.dimLock.set(this.level.dimension().location().toString());
            for (int i = 1; i <= 2; ++i) {
                this.level.setBlockAndUpdate(this.worldPosition.above(i), ((ChaosCrystal)((Object)DEContent.CHAOS_CRYSTAL_PART.get())).defaultBlockState());
                this.level.setBlockAndUpdate(this.worldPosition.below(i), ((ChaosCrystal)((Object)DEContent.CHAOS_CRYSTAL_PART.get())).defaultBlockState());
                BlockEntity tile = this.level.getBlockEntity(this.worldPosition.above(i));
                if (tile instanceof TileChaosCrystal) {
                    ((TileChaosCrystal)tile).parentPos.set(this.worldPosition);
                }
                if (!((tile = this.level.getBlockEntity(this.worldPosition.below(i))) instanceof TileChaosCrystal)) continue;
                ((TileChaosCrystal)tile).parentPos.set(this.worldPosition);
            }
            this.validatePlacement = false;
        }
        if (!this.getBlockState().is((Block)DEContent.CHAOS_CRYSTAL.get())) {
            return;
        }
        ++this.tick;
        if (this.tick > 1 && !this.level.isClientSide && this.hasBeenMoved()) {
            this.level.removeBlock(this.worldPosition, false);
        }
        if (!this.level.isClientSide && this.soundTimer-- <= 0) {
            this.soundTimer = 3600 + this.level.random.nextInt(1200);
            BCoreNetwork.sendSound((Level)this.level, (BlockPos)this.worldPosition, (SoundEvent)((SoundEvent)DESounds.CHAOS_CHAMBER_AMBIENT.get()), (SoundSource)SoundSource.AMBIENT, (float)1.5f, (float)(this.level.random.nextFloat() * 0.4f + 0.8f), (boolean)false);
        }
        if (!this.level.isClientSide && this.level instanceof ServerLevel && this.guardianDefeated.get() && this.level.random.nextInt(50) == 0) {
            int x = 5 - this.level.random.nextInt(11);
            int z = 5 - this.level.random.nextInt(11);
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level);
            bolt.setPos((double)(this.worldPosition.getX() + x), (double)this.level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, this.worldPosition).getY(), (double)(this.worldPosition.getZ() + z));
            bolt.noCulling = true;
            this.level.addFreshEntity((Entity)bolt);
        }
    }

    public void detonate(Entity entity) {
        if (this.level.isClientSide) {
            return;
        }
        if (this.parentPos.notNull()) {
            BlockEntity tile = this.level.getBlockEntity(this.parentPos.get());
            if (tile instanceof TileChaosCrystal && !((TileChaosCrystal)tile).removing) {
                ((TileChaosCrystal)tile).detonate(entity);
                this.level.destroyBlock(tile.getBlockPos(), true, entity);
            }
            return;
        }
        if (this.removing) {
            return;
        }
        this.removing = true;
        this.level.setBlockAndUpdate(this.worldPosition.above(), Blocks.AIR.defaultBlockState());
        this.level.setBlockAndUpdate(this.worldPosition.above(2), Blocks.AIR.defaultBlockState());
        this.level.setBlockAndUpdate(this.worldPosition.below(), Blocks.AIR.defaultBlockState());
        this.level.setBlockAndUpdate(this.worldPosition.below(2), Blocks.AIR.defaultBlockState());
        if (!this.guardianDefeated.get()) {
            Level world = this.level;
            BlockPos pos = this.worldPosition;
            ProcessHandler.addProcess((IProcess)new DelayedTask.Task(1, () -> {
                world.setBlock(pos, ((ChaosCrystal)((Object)((Object)DEContent.CHAOS_CRYSTAL.get()))).defaultBlockState(), 3);
                TileChaosCrystal tileChaosShard = (TileChaosCrystal)world.getBlockEntity(pos);
                tileChaosShard.onValidPlacement();
            }));
            return;
        }
        Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)new ItemStack((ItemLike)DEContent.CHAOS_SHARD.get(), DEConfig.chaosDropCount));
        this.level.removeBlock(this.worldPosition, false);
        if (DEOldConfig.disableChaosIslandExplosion || this.hasBeenMoved()) {
            // empty if block
        }
    }

    public void setDefeated() {
        this.guardianDefeated.set(true);
        super.tick();
    }

    public void writeExtraNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.writeExtraNBT(provider, compound);
        if (this.validatePlacement) {
            compound.putBoolean("validate_placement", true);
        }
    }

    public void readExtraNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.readExtraNBT(provider, compound);
        this.validatePlacement = compound.contains("validate_placement") && compound.getBoolean("validate_placement");
    }

    public void onValidPlacement() {
        this.validatePlacement = true;
    }

    private boolean hasBeenMoved() {
        return this.posLock.get() != this.worldPosition.asLong() || !this.dimLock.get().equals(this.level.dimension().location().toString());
    }

    public boolean saveToItem() {
        return false;
    }

    public boolean attemptingBreak(Player player) {
        if (this.parentPos.isNull()) {
            if (player != null && player.getAbilities().instabuild) {
                this.guardianDefeated.set(true);
            }
            return this.guardianDefeated.get();
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.parentPos.get());
        if (blockEntity instanceof TileChaosCrystal) {
            TileChaosCrystal tile = (TileChaosCrystal)blockEntity;
            return tile.attemptingBreak(player);
        }
        return false;
    }
}

