/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleEntity<T extends ModuleData<T>> {
    public static final Codec<ModuleEntity<?>> CODEC = new ModuleEntityCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, ModuleEntity<?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ModuleEntity<?>>(){

        public ModuleEntity<?> decode(RegistryFriendlyByteBuf buf) {
            Module module = (Module)DEModules.streamCodec().decode((Object)buf);
            return (ModuleEntity)module.entityStreamCodec().decode((Object)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ModuleEntity<?> entity) {
            DEModules.streamCodec().encode((Object)buf, entity.getModule());
            entity.getModule().entityStreamCodec().encode((Object)buf, entity);
        }
    };
    @Deprecated
    protected ModuleHost host;
    protected final Module<T> module;
    private int gridX;
    private int gridY;

    protected ModuleEntity(Module<T> module) {
        this.module = module;
    }

    protected ModuleEntity(Module<T> module, int gridX, int gridY) {
        this.module = module;
        this.gridX = gridX;
        this.gridY = gridY;
    }

    public abstract ModuleEntity<?> copy();

    public void setHost(ModuleHost host) {
        this.host = host;
    }

    public void tick(ModuleContext context) {
    }

    public void onInstalled(ModuleContext context) {
    }

    public void onRemoved(ModuleContext context) {
    }

    public void getEntityProperties(List<ConfigProperty> properties) {
    }

    public void getAttributeModifiers(EquipmentSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
    }

    public void clearCaches() {
    }

    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
    }

    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
    }

    public Module<T> getModule() {
        return this.module;
    }

    public void setPos(int gridX, int gridY) {
        this.setGridX(gridX);
        this.setGridY(gridY);
    }

    public void setGridX(int gridX) {
        if (this.gridX != gridX) {
            this.markDirty();
        }
        this.gridX = gridX;
    }

    public void setGridY(int gridY) {
        if (this.gridY != gridY) {
            this.markDirty();
        }
        this.gridY = gridY;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public int getMaxGridX() {
        return this.gridX + this.module.getProperties().getWidth();
    }

    public int getMaxGridY() {
        return this.gridY + this.module.getProperties().getHeight();
    }

    public int getWidth() {
        return this.module.getProperties().getWidth();
    }

    public int getHeight() {
        return this.module.getProperties().getHeight();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean stackRender, float partialTicks) {
        if (stackRender) {
            // empty if block
        }
        int colour = this.getModuleColour(this.module);
        render.rect((double)x, (double)y, (double)width, (double)height, colour);
        render.borderRect((double)x, (double)y, (double)width, (double)height, 1.0, colour, GuiRender.mixColours((int)colour, (int)0x20202000, (boolean)true));
        if (this.module.getProperties().getTechLevel() == TechLevel.CHAOTIC) {
            TransformingVertexConsumer builder = new TransformingVertexConsumer(render.buffers().getBuffer(RenderType.glint()), render.pose());
            builder.addVertex((float)x, (float)(y + height), 0.0f).setUv(0.0f, (float)height / (float)width / 64.0f);
            builder.addVertex((float)(x + width), (float)(y + height), 0.0f).setUv((float)width / (float)height / 64.0f, (float)height / (float)width / 64.0f);
            builder.addVertex((float)(x + width), (float)y, 0.0f).setUv((float)width / (float)height / 64.0f, 0.0f);
            builder.addVertex((float)x, (float)y, 0.0f).setUv(0.0f, 0.0f);
            RenderUtils.endBatch((MultiBufferSource)render.buffers());
        }
        Material texture = this.module.getTexture();
        TextureAtlasSprite sprite = texture.sprite();
        float ar = (float)sprite.contents().width() / (float)sprite.contents().height();
        float iar = (float)sprite.contents().height() / (float)sprite.contents().width();
        if (iar * (float)width <= (float)height) {
            double h = (float)width * iar;
            render.texRect(texture, (double)x, (double)y + (double)height / 2.0 - h / 2.0, (double)width, h);
        } else {
            double w = (float)height * ar;
            render.texRect(texture, (double)x + (double)width / 2.0 - w / 2.0, (double)y, w, (double)height);
        }
        if (!stackRender && GuiRender.isInRect((int)x, (int)y, (int)width, (int)height, (double)mouseX, (double)mouseY)) {
            render.rect((double)x, (double)y, (double)width, (double)height, 0x50FFFFFF);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderModuleOverlay(GuiElement<?> parent, ModuleContext context, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, float partialTicks, int hoverTicks) {
        if (hoverTicks > 10) {
            Minecraft mc = Minecraft.getInstance();
            Item item = this.getModule().getItem();
            ItemStack stack = new ItemStack((ItemLike)item);
            this.saveEntityToStack(stack, context);
            List list = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            render.componentTooltip(list, mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void addToolTip(List<Component> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addHostHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
    }

    public boolean clientModuleClicked(GuiElement<?> parent, Player player, int x, int y, int width, int height, double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean moduleClicked(Player player, double x, double y, int button, ClickType clickType) {
        return false;
    }

    public boolean checkPos(int gridX, int gridY) {
        return this.gridX == gridX && this.gridY == gridY;
    }

    public boolean isPosValid(int gridWidth, int gridHeight) {
        return this.gridX >= 0 && this.gridY >= 0 && this.getMaxGridX() < gridWidth && this.getMaxGridY() < gridHeight;
    }

    public boolean contains(int gridX, int gridY) {
        return gridX >= this.gridX && gridX < this.gridX + this.module.getProperties().getWidth() && gridY >= this.gridY && gridY < this.gridY + this.module.getProperties().getHeight();
    }

    public boolean intersects(ModuleEntity other) {
        int tw = this.getWidth();
        int th = this.getHeight();
        int rw = other.getWidth();
        int rh = other.getHeight();
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.gridX;
        int ty = this.gridY;
        int rx = other.gridX;
        int ry = other.gridY;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    protected int getModuleColour(Module<?> module) {
        return switch (module.getProperties().getTechLevel()) {
            default -> throw new MatchException(null, null);
            case TechLevel.DRACONIUM -> -14793322;
            case TechLevel.WYVERN -> -12839599;
            case TechLevel.DRACONIC -> -3462656;
            case TechLevel.CHAOTIC -> -15658735;
        };
    }

    public String toString() {
        return "ModuleEntity{module=" + String.valueOf(DEModules.REGISTRY.getKey(this.module)) + ", gridX=" + this.gridX + ", gridY=" + this.gridY + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModuleEntity)) {
            return false;
        }
        ModuleEntity that = (ModuleEntity)o;
        return this.gridX == that.gridX && this.gridY == that.gridY && Objects.equals(this.module, that.module);
    }

    public int hashCode() {
        return Objects.hash(this.module, this.gridX, this.gridY);
    }

    public void sendMessageToServer(RegistryAccess registryAccess, Consumer<MCDataOutput> dataConsumer) {
        DraconicNetwork.sendModuleMessage(registryAccess, this.getGridX(), this.getGridY(), dataConsumer);
    }

    public void handleClientMessage(MCDataInput input) {
    }

    public void markDirty() {
        if (this.host != null) {
            this.host.markDirty();
        }
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    protected void drawChargeProgress(GuiRender render, int x, int y, int width, int height, double progress, @Nullable Component text1, @Nullable Component text2) {
        double diameter = (double)Math.min(width, height) * 0.425;
        render.rect((double)x, (double)y, (double)width, (double)height, 0x60FF0000);
        TransformingVertexConsumer builder = new TransformingVertexConsumer(render.buffers().getBuffer(RenderUtils.FAN_TYPE), render.pose());
        builder.addVertex((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, 0.0f).setColor(0, 255, 255, 128);
        for (double d = 0.0; d <= 1.0; d += 0.03333333333333333) {
            double angle = d * progress + 0.5 - progress;
            double vertX = (double)x + (double)width / 2.0 + Math.sin(angle * (Math.PI * 2)) * diameter;
            double vertY = (double)y + (double)height / 2.0 + Math.cos(angle * (Math.PI * 2)) * diameter;
            builder.addVertex((float)vertX, (float)vertY, 0.0f).setColor(255, 255, 255, 128);
        }
        RenderUtils.endBatch((MultiBufferSource)render.buffers());
        if (text1 != null) {
            ModuleEntity.drawBackgroundString(render, text1, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f - (float)(text2 == null ? 4 : 8), 0, -2147418368, 1, false, true);
        }
        if (text2 != null) {
            ModuleEntity.drawBackgroundString(render, text2, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f + 1.0f, 0, -2147418368, 1, false, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawBackgroundString(GuiRender render, Component text, float x, float y, int colour, int background, int padding, boolean shadow, boolean centered) {
        int width = render.font().width((FormattedText)text);
        x = centered ? x - (float)width / 2.0f : x;
        double d = x - (float)padding;
        double d2 = y - (float)padding;
        double d3 = width + padding * 2;
        Objects.requireNonNull(render.font());
        render.rect(d, d2, d3, (double)(9 - 2 + padding * 2), background);
        render.drawString(text, (double)x, (double)y, colour, shadow);
    }

    public static <T> Optional<T> optionalDefault(T input, Optional<T> defaultVal) {
        return input == null ? defaultVal : Optional.of(input);
    }

    public static class ModuleEntityCodec
    implements Codec<ModuleEntity<?>> {
        public <T> DataResult<Pair<ModuleEntity<?>, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
                DecoderState decoder = new DecoderState(ops);
                stream.accept(decoder::accept);
                return decoder.build();
            });
        }

        public <T> DataResult<T> encode(ModuleEntity<?> input, DynamicOps<T> ops, T prefix) {
            ListBuilder builder = ops.listBuilder();
            builder.add(DEModules.codec().encodeStart(ops, input.getModule()));
            builder.add(input.getModule().entityCodec().encodeStart(ops, input));
            return builder.build(prefix);
        }

        private static class DecoderState<T> {
            private final DynamicOps<T> ops;
            private final Stream.Builder<T> failed = Stream.builder();
            private int count;
            private Module<?> module = null;
            private ModuleEntity<?> entity = null;

            private DecoderState(DynamicOps<T> ops) {
                this.ops = ops;
            }

            public void accept(T value) {
                ++this.count;
                if (this.module == null) {
                    DataResult elementResult = DEModules.codec().decode(this.ops, value);
                    elementResult.error().ifPresent(error -> this.failed.add(value));
                    elementResult.resultOrPartial().ifPresent(e -> {
                        this.module = (Module)e.getFirst();
                    });
                } else {
                    DataResult elementResult = this.module.entityCodec().decode(this.ops, value);
                    elementResult.error().ifPresent(error -> this.failed.add(value));
                    elementResult.resultOrPartial().ifPresent(e -> {
                        this.entity = (ModuleEntity)e.getFirst();
                    });
                }
            }

            public DataResult<Pair<ModuleEntity<?>, T>> build() {
                if (this.count != 2) {
                    return DataResult.error(() -> "ConfigProperty is invalid. Read: " + this.count + " inputs, expected is 2");
                }
                Object errors = this.ops.createList(this.failed.build());
                return DataResult.success((Object)Pair.of(this.entity, (Object)errors), (Lifecycle)Lifecycle.stable());
            }
        }
    }
}

