/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.brandon3055.draconicevolution.api.crafting.StackIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public interface IFusionRecipe
extends Recipe<IFusionInventory> {
    default public ItemStack getToastSymbol() {
        if (DraconicAPI.CRAFTING_CORE != null) {
            return new ItemStack((ItemLike)DraconicAPI.CRAFTING_CORE);
        }
        return new ItemStack((ItemLike)Blocks.CRAFTING_TABLE);
    }

    default public RecipeType<?> getType() {
        return (RecipeType)DraconicAPI.FUSION_RECIPE_TYPE.get();
    }

    public TechLevel getRecipeTier();

    public long getEnergyCost();

    default public NonNullList<Ingredient> getIngredients() {
        return this.fusionIngredients().stream().map(IFusionIngredient::get).collect(Collectors.toCollection(NonNullList::create));
    }

    public List<IFusionIngredient> fusionIngredients();

    public Ingredient getCatalyst();

    default public boolean matches(IFusionInventory inv, Level level) {
        if (!this.getCatalyst().test(inv.getCatalystStack())) {
            return false;
        }
        ArrayList<IFusionInjector> injectors = new ArrayList<IFusionInjector>(inv.getInjectors());
        for (Ingredient ingredient : this.getIngredients()) {
            IFusionInjector match = injectors.stream().filter(e -> ingredient.test(e.getInjectorStack())).findFirst().orElse(null);
            if (match == null) {
                return false;
            }
            injectors.remove(match);
        }
        return injectors.stream().allMatch(e -> e.getInjectorStack().isEmpty());
    }

    default public void tickFusionState(IFusionStateMachine stateMachine, IFusionInventory inv, Level level) {
        switch (stateMachine.getFusionState()) {
            case START: {
                if (!this.matches(inv, level)) {
                    stateMachine.cancelCraft();
                    return;
                }
                long itemEnergy = this.getEnergyCost() / (long)this.fusionIngredients().size() + (long)inv.getInjectors().size();
                inv.getInjectors().stream().filter(e -> !e.getInjectorStack().isEmpty()).forEach(e -> e.setEnergyRequirement(itemEnergy, itemEnergy / (long)DEConfig.fusionChargeTime.get(e.getInjectorTier().index).intValue()));
                stateMachine.setFusionStatus(0.0, (Component)Component.translatable((String)"fusion_status.draconicevolution.charging", (Object[])new Object[]{0}).withStyle(ChatFormatting.GREEN));
                stateMachine.setFusionState(IFusionStateMachine.FusionState.CHARGING);
                stateMachine.setCraftAnimation(0.0f, 0);
                break;
            }
            case CHARGING: {
                long totalCharge = inv.getInjectors().stream().mapToLong(IFusionInjector::getInjectorEnergy).sum();
                stateMachine.setFusionStatus((double)totalCharge / (double)this.getEnergyCost(), (Component)Component.translatable((String)"fusion_status.draconicevolution.charging", (Object[])new Object[]{(double)Math.round((double)totalCharge / (double)this.getEnergyCost() * 1000.0) / 10.0}).withStyle(ChatFormatting.GREEN));
                if (totalCharge < this.getEnergyCost()) break;
                stateMachine.setFusionStatus(0.0, (Component)Component.translatable((String)"fusion_status.draconicevolution.crafting", (Object[])new Object[]{0}).withStyle(ChatFormatting.GREEN));
                stateMachine.setCounter(0);
                int craftTime = DEConfig.fusionCraftTime.get(inv.getMinimumTier().index);
                stateMachine.setCraftAnimation(0.0f, craftTime);
                stateMachine.setFusionState(IFusionStateMachine.FusionState.CRAFTING);
                break;
            }
            case CRAFTING: {
                int craftTime = DEConfig.fusionCraftTime.get(inv.getMinimumTier().index);
                int counter = stateMachine.getCounter();
                stateMachine.setCraftAnimation((float)counter / (float)craftTime, craftTime);
                stateMachine.setCounter(counter + 1);
                stateMachine.setFusionStatus((double)counter / (double)craftTime, (Component)Component.translatable((String)"fusion_status.draconicevolution.crafting", (Object[])new Object[]{(double)Math.round((double)counter / (double)craftTime * 1000.0) / 10.0}).withStyle(ChatFormatting.GREEN));
                if (counter < craftTime) break;
                if (inv.getInjectors().stream().anyMatch(e -> !e.validate())) {
                    stateMachine.cancelCraft();
                    return;
                }
                if (!this.matches(inv, level) || !this.canStartCraft(inv, level, null)) {
                    stateMachine.cancelCraft();
                    return;
                }
                IFusionRecipe.completeCraft(inv, level, this);
                stateMachine.completeCraft();
            }
        }
    }

    public static void completeCraft(IFusionInventory inv, Level level, IFusionRecipe recipe) {
        ArrayList<IFusionInjector> injectors = new ArrayList<IFusionInjector>(inv.getInjectors());
        block0: for (IFusionIngredient ingredient : recipe.fusionIngredients()) {
            for (IFusionInjector injector : injectors) {
                ItemStack stack = injector.getInjectorStack();
                if (stack.isEmpty() || !ingredient.get().test(stack) || injector.getInjectorTier().index < recipe.getRecipeTier().index) continue;
                if (!ingredient.consume()) continue block0;
                if (stack.hasCraftingRemainingItem()) {
                    stack = stack.getItem().getCraftingRemainingItem(stack);
                } else {
                    stack.shrink(1);
                }
                injector.setInjectorStack(stack);
                injector.setInjectorEnergy(0L);
                injectors.remove(injector);
                continue block0;
            }
        }
        int catCount = 1;
        if (recipe.getCatalyst().getCustomIngredient() instanceof StackIngredient) {
            catCount = ((StackIngredient)recipe.getCatalyst().getCustomIngredient()).getCount();
        }
        ItemStack catalyst = inv.getCatalystStack();
        ItemStack result = recipe.assemble(inv, (HolderLookup.Provider)level.registryAccess());
        catalyst.shrink(catCount);
        inv.setCatalystStack(catalyst);
        ItemStack outputStack = inv.getOutputStack();
        if (outputStack.isEmpty()) {
            inv.setOutputStack(result.copy());
        } else {
            outputStack.grow(result.getCount());
        }
    }

    default public boolean canStartCraft(IFusionInventory inv, Level level, @Nullable Consumer<Component> userStatus) {
        ItemStack result;
        ItemStack output = inv.getOutputStack();
        if (!(output.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)(result = this.assemble(inv, (HolderLookup.Provider)level.registryAccess()))) && output.getCount() + result.getCount() <= result.getItem().getMaxStackSize(result))) {
            if (userStatus != null) {
                userStatus.accept((Component)Component.translatable((String)"fusion_status.draconicevolution.output_obstructed").withStyle(ChatFormatting.RED));
            }
            return false;
        }
        if (inv.getMinimumTier().index < this.getRecipeTier().index) {
            if (userStatus != null) {
                userStatus.accept((Component)Component.translatable((String)"fusion_status.draconicevolution.tier_low").withStyle(ChatFormatting.RED));
            }
            return false;
        }
        if (userStatus != null) {
            userStatus.accept((Component)Component.translatable((String)"fusion_status.draconicevolution.ready").withStyle(ChatFormatting.GREEN));
        }
        return true;
    }

    default public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    default public boolean isSpecial() {
        return true;
    }

    public static interface IFusionIngredient {
        public Ingredient get();

        public boolean consume();
    }
}

