/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.mehvahdjukaar.amendments.common.ProjectileStats;
import net.mehvahdjukaar.amendments.common.entity.FireballExplosion;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LargeFireball.class})
public abstract class LargeFireballMixin
extends Entity {
    public LargeFireballMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"onHit(Lnet/minecraft/world/phys/HitResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;explode(Lnet/minecraft/world/entity/Entity;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;)Lnet/minecraft/world/level/Explosion;")})
    public Explosion amendments$fireballExplosion(Level instance, Entity source, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, Operation<Explosion> original) {
        if (CommonConfigs.FIREBALL_EXPLOSION.get().booleanValue()) {
            FireballExplosion.ExtraSettings settings = new FireballExplosion.ExtraSettings();
            settings.onFireSeconds = ProjectileStats.GHAST_FIREBALL.indirectHitFireSeconds();
            settings.soundVolume = ProjectileStats.GHAST_FIREBALL.soundVolume();
            return FireballExplosion.explodeServer(instance, source, null, null, x, y, z, radius, fire, explosionInteraction, settings);
        }
        return (Explosion)original.call(new Object[]{instance, source, x, y, z, Float.valueOf(radius), fire, explosionInteraction});
    }

    @Inject(method={"onHit(Lnet/minecraft/world/phys/HitResult;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void amendments$cancelExplosion(HitResult result, CallbackInfo ci) {
        if (this.getRemainingFireTicks() <= 0) {
            if (!this.level().isClientSide) {
                this.discard();
            }
            ci.cancel();
        }
    }
}

