/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.common.effect.DoubleJumpEffect;
import com.klikli_dev.occultism.registry.OccultismDataStorage;
import com.klikli_dev.occultism.registry.OccultismTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;

public class MovementUtil {
    public static boolean doubleJump(Player player) {
        if (!MovementUtil.allowDoubleJump(player)) {
            return false;
        }
        int jumps = (Integer)player.getData(OccultismDataStorage.DOUBLE_JUMP);
        if (jumps < DoubleJumpEffect.getMaxJumps(player)) {
            player.jumpFromGround();
            player.setData(OccultismDataStorage.DOUBLE_JUMP, (Object)(jumps + 1));
            return true;
        }
        return false;
    }

    public static boolean allowDoubleJump(Player player) {
        boolean swimming;
        boolean bl = swimming = player.isInWater() || player.isInLava();
        if (player.onGround() || player.isPassenger() || player.getAbilities().flying || swimming) {
            return false;
        }
        ItemStack itemstack = player.getItemBySlot(EquipmentSlot.CHEST);
        return !itemstack.is(OccultismTags.Items.ELYTRA) || itemstack.getDamageValue() > 0 && !ElytraItem.isFlyEnabled((ItemStack)itemstack);
    }
}

