/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.common.container.satchel.StorageSatchelContainer;
import com.klikli_dev.occultism.common.item.storage.SatchelItem;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.util.CuriosUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MessageOpenSatchel
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"open_satchel");
    public static final CustomPacketPayload.Type<MessageOpenSatchel> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageOpenSatchel> STREAM_CODEC = CustomPacketPayload.codec(MessageOpenSatchel::encode, MessageOpenSatchel::new);

    public MessageOpenSatchel(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageOpenSatchel() {
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        int selectedSlot = -1;
        ItemStack backpackStack = CuriosUtil.getBackpack((Player)player);
        if (!(backpackStack.getItem() instanceof SatchelItem)) {
            selectedSlot = CuriosUtil.getFirstBackpackSlot((Player)player);
            ItemStack itemStack = backpackStack = selectedSlot > 0 ? player.getInventory().getItem(selectedSlot) : ItemStack.EMPTY;
        }
        if (backpackStack.getItem() instanceof SatchelItem) {
            ItemStack finalBackpackStack = backpackStack;
            int finalSelectedSlot = selectedSlot;
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, unused) -> new StorageSatchelContainer(id, playerInventory, ((SatchelItem)finalBackpackStack.getItem()).getInventory(player, finalBackpackStack), finalSelectedSlot), backpackStack.getDisplayName()), buffer -> buffer.writeVarInt(finalSelectedSlot));
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

