/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="occultism", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class TooltipHandler {
    private static final List<String> namespacesToListenFor = new ArrayList<String>();

    public static void registerNamespaceToListenTo(String namespace) {
        namespacesToListenFor.add(namespace);
    }

    @SubscribeEvent
    public static void onAddInformation(ItemTooltipEvent event) {
        String tooltipKey;
        boolean tooltipExists;
        String namespace;
        String translationKey;
        ItemStack stack = event.getItemStack();
        if (stack.has(OccultismDataComponents.SPIRIT_NAME) && I18n.exists((String)(translationKey = stack.getDescriptionId() + ".occultism_spirit_tooltip"))) {
            event.getToolTip().add(Component.translatable((String)translationKey, (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
        }
        if (((Boolean)Occultism.CLIENT_CONFIG.visuals.showItemTagsInTooltip.get()).booleanValue() && event.getFlags().isAdvanced()) {
            List tooltips = event.getToolTip();
            Holder item = event.getItemStack().getItemHolder();
            BuiltInRegistries.ITEM.getTags().filter(p -> ((HolderSet.Named)p.getSecond()).contains(item)).forEach(tag -> tooltips.add(Component.literal((String)((TagKey)tag.getFirst()).toString()).withStyle(ChatFormatting.DARK_GRAY)));
        }
        if (namespacesToListenFor.contains(namespace = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace()) && (tooltipExists = I18n.exists((String)(tooltipKey = stack.getDescriptionId() + ".auto_tooltip")))) {
            event.getToolTip().add(Component.translatable((String)tooltipKey).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
    }
}

