/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.familiar_rituals;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookSpiritFireRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ResurrectionEntry
extends EntryProvider {
    public static final String ENTRY_ID = "resurrection";

    public ResurrectionEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("soul_shard", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_SHARD_ITEM.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Soul Shards");
        this.pageText("If a familiar dies it does not merely return to the Otherworld. Due to the close connection to the summoner a splinter of the familiar's soul remains in the mortal realm.\n\\\n\\\nThis splinter - shard - can be used to re-summon the familiar more easily.\n");
        this.page("description", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Resurrection");
        this.pageText("The resurrection is a relatively simple process. The soul shard is strengthened with {0} until it is strong enough to allow the familiar to return to the mortal realm and create a new body for itself.\n\\\n\\\nThe essence is obtained by growing (lots of) Demon's Dream plants.\n", new Object[]{this.itemLink((ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get())});
        this.page("recipe_essence", () -> (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/demons_dream_essence_from_fruit_or_seed")));
        this.lang().add(this.context().pageText(), "Fruit and seeds can be mixed freely to create the essence.\n");
        this.page("recipe_essence_pure", () -> (BookSpiritFireRecipePageModel)BookSpiritFireRecipePageModel.create().withRecipeId1(this.modLoc("spirit_fire/otherworld_essence")));
        this.page("ritual", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/resurrect_familiar")));
    }

    protected String entryName() {
        return "Resurrecting Familiars";
    }

    protected String entryDescription() {
        return "How to bring back a familiar from the dead.";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)OccultismItems.SOUL_SHARD_ITEM.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

