/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit.calling;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SetBaseItemMode
extends ItemMode {
    public SetBaseItemMode() {
        super("set_base", true);
    }

    public boolean setSpiritBaseLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.getServer(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setWorkAreaPosition(pos);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.getBlockState(pos).getBlock().getDescriptionId();
                player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_set_base", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().getName().getString()), Component.translatable((String)blockName)}), true);
                return true;
            }
            player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
        }
        return false;
    }

    @Override
    public boolean handle(BlockEntity blockEntity, Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        return this.setSpiritBaseLocation(player, world, pos, stack, face);
    }
}

