/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed;

import com.klikli_dev.occultism.common.entity.possessed.PossessedMob;
import com.klikli_dev.occultism.registry.OccultismEntities;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class PossessedBeeEntity
extends Bee
implements PossessedMob {
    private static final int MAX_BEES_PER_TIME = 10;
    private static final long TIME_WINDOW_TICKS = 1200L;
    private static final AtomicInteger beeSpawnCounter = new AtomicInteger(0);
    private static long lastResetGameTime = 0L;

    public PossessedBeeEntity(EntityType<? extends Bee> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Bee.createAttributes().add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.06).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_SPEED, 3.0);
    }

    public boolean doHurtTarget(Entity entity) {
        DamageSource damagesource = this.damageSources().sting((LivingEntity)this);
        boolean flag = entity.hurt(damagesource, (float)((int)this.getAttributeValue(Attributes.ATTACK_DAMAGE)));
        if (flag) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity, (DamageSource)damagesource);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.setStingerCount(livingentity.getStingerCount() + 1);
                int i = 10;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    i = 20;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    i = 30;
                }
                livingentity.addEffect(new MobEffectInstance(MobEffects.POISON, i * 20, 0), (Entity)this);
            }
            this.playSound(SoundEvents.BEE_STING, 1.0f, 1.0f);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        LivingEntity livingentity = this.getTarget();
        if (livingentity == null || !((double)this.random.nextFloat() < this.getAttributeValue(Attributes.SPAWN_REINFORCEMENTS_CHANCE)) || !this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) return super.hurt(source, amount);
        long currentGameTime = this.level().getGameTime();
        Class<PossessedBeeEntity> clazz = PossessedBeeEntity.class;
        synchronized (PossessedBeeEntity.class) {
            if (currentGameTime - lastResetGameTime > 1200L) {
                beeSpawnCounter.set(0);
                lastResetGameTime = currentGameTime;
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (beeSpawnCounter.get() >= 10) return super.hurt(source, amount);
            Bee bee = (Bee)OccultismEntities.POSSESSED_BEE.get().create(this.level());
            double offsetX = this.level().getRandom().nextGaussian() * (double)(1 + this.level().getRandom().nextInt(4));
            double offsetZ = this.level().getRandom().nextGaussian() * (double)(1 + this.level().getRandom().nextInt(4));
            bee.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)this.level().getRandom().nextInt(360), 0.0f);
            this.level().addFreshEntity((Entity)bee);
            beeSpawnCounter.incrementAndGet();
            return super.hurt(source, amount);
        }
    }

    @Override
    public EntityType basedMob() {
        return EntityType.BEE;
    }
}

