/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.sensor;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSelectBlock;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.registry.OccultismSensors;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;

public class NearestCropSensor<E extends SpiritEntity>
extends ExtendedSensor<E> {
    public static final int DEFAULT_SCAN_RATE_TICKS = 100;
    public static final int RESCAN_EMPTY_WORK_AREA_AFTER_TICKS = 400;
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{OccultismMemoryTypes.NEAREST_CROP.get(), OccultismMemoryTypes.NON_CROP.get()});

    public NearestCropSensor() {
        this.setScanRate(entity -> 100);
    }

    public static boolean isCropSoil(Level level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() instanceof FarmBlock;
    }

    public static boolean isGrowthCrop(Level level, BlockPos pos) {
        CropBlock crop;
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        return block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(blockState);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return OccultismSensors.NEAREST_CROP.get();
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull E entity) {
        if (BrainUtils.hasMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get())) {
            return;
        }
        if (BrainUtils.hasMemory(entity, OccultismMemoryTypes.NO_CROP_IN_WORK_AREA.get())) {
            return;
        }
        Set nonCrop = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.NON_CROP.get(), HashSet::new);
        Set unreachableCrops = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_CROPS.get(), HashSet::new);
        BlockPos workAreaCenter = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_CENTER.get());
        Integer workAreaSize = (Integer)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_SIZE.get());
        if (Occultism.DEBUG.debugAI) {
            for (BlockPos crop : unreachableCrops) {
                Networking.sendToTracking(entity, new MessageSelectBlock(crop, 10000, 16753920));
            }
            for (BlockPos crop : nonCrop) {
                Networking.sendToTracking(entity, new MessageSelectBlock(crop, 10000, 16753920));
            }
        }
        Stream<BlockPos> blocksInWorkArea = workAreaCenter != null && workAreaSize != null ? BlockPos.betweenClosedStream((BlockPos)workAreaCenter.offset(-workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2), (BlockPos)workAreaCenter.offset(workAreaSize / 2, workAreaSize / 2, workAreaSize / 2)).map(BlockPos::immutable) : BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1);
        List potentialRoots = blocksInWorkArea.filter(pos -> NearestCropSensor.isGrowthCrop((Level)level, pos) && NearestCropSensor.isCropSoil((Level)level, pos.below()) && !nonCrop.contains(pos) && !unreachableCrops.contains(pos)).collect(Collectors.toList());
        boolean foundCrop = false;
        if (!potentialRoots.isEmpty()) {
            potentialRoots.sort(new BlockSorter((Entity)entity));
            for (BlockPos potentialRoot : potentialRoots) {
                if (Occultism.DEBUG.debugAI) {
                    Networking.sendToTracking(entity, new MessageSelectBlock(potentialRoot, 5000, 0xFFFFFF));
                }
                if (NearestCropSensor.isGrowthCrop((Level)level, potentialRoot)) {
                    boolean isReachable = false;
                    for (Direction facing : Direction.Plane.HORIZONTAL) {
                        BlockPos pos2 = potentialRoot.relative(facing);
                        if (!level.isEmptyBlock(pos2) && !(level.getBlockState(pos2).getBlock() instanceof CropBlock)) continue;
                        isReachable = true;
                        break;
                    }
                    if (!isReachable) continue;
                    if (Occultism.DEBUG.debugAI) {
                        Networking.sendToTracking(entity, new MessageSelectBlock(potentialRoot, 50000, 0x800080));
                    }
                    BrainUtils.setMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get(), (Object)potentialRoot);
                    foundCrop = true;
                    break;
                }
                nonCrop.add(potentialRoot);
                BrainUtils.setMemory(entity, OccultismMemoryTypes.NON_CROP.get(), (Object)nonCrop);
                if (!Occultism.DEBUG.debugAI) continue;
                Networking.sendToTracking(entity, new MessageSelectBlock(potentialRoot, 10000, 0xFFFF00));
            }
        }
        if (!foundCrop) {
            BrainUtils.clearMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get());
            BrainUtils.setForgettableMemory(entity, OccultismMemoryTypes.NO_CROP_IN_WORK_AREA.get(), (Object)true, (int)400);
        }
    }
}

