/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.satchel;

import com.klikli_dev.occultism.common.container.satchel.SatchelInventory;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.CuriosUtil;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractSatchelContainer
extends AbstractContainerMenu {
    protected Container satchelInventory;
    protected Inventory playerInventory;
    protected int selectedSlot;
    protected ItemStack satchelStack;

    public AbstractSatchelContainer(@Nullable MenuType<?> menuType, int id, Inventory playerInventory, Container satchelInventory, int selectedSlot) {
        super(menuType, id);
        this.satchelInventory = satchelInventory;
        this.playerInventory = playerInventory;
        this.selectedSlot = selectedSlot;
        this.satchelStack = this.selectedSlot == -1 ? CuriosUtil.getBackpack(playerInventory.player) : playerInventory.player.getInventory().getItem(this.selectedSlot).copy();
        this.setupSatchelSlots();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
    }

    public void broadcastChanges() {
        if (this.satchelInventory instanceof SatchelInventory) {
            ((SatchelInventory)this.satchelInventory).writeItemStack();
        }
        super.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= this.satchelInventory.getContainerSize() && itemstack.getItem() == OccultismItems.SATCHEL.get()) {
                return ItemStack.EMPTY;
            }
            if (index < this.satchelInventory.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.satchelInventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.satchelInventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        if (this.selectedSlot == -1) {
            return CuriosUtil.getBackpack(player).getItem() == this.satchelStack.getItem();
        }
        if (this.selectedSlot < 0 || this.selectedSlot >= player.getInventory().getContainerSize()) {
            return false;
        }
        return player.getInventory().getItem(this.selectedSlot).getItem() == this.satchelStack.getItem();
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 174;
        int playerInventoryLeft = 44;
        int hotbarSlots = 9;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + hotbarSlots, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 44;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected abstract void setupSatchelSlots();
}

