/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.common.block.DirectionalBlockShape;
import com.klikli_dev.occultism.common.blockentity.SacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.item.spirit.BookOfBindingItem;
import com.klikli_dev.occultism.common.item.tool.GuideBookItem;
import com.klikli_dev.occultism.crafting.recipe.BoundBookOfBindingRecipe;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SacrificialBowlBlock
extends DirectionalBlock
implements EntityBlock {
    public static final MapCodec<SacrificialBowlBlock> CODEC = SacrificialBowlBlock.simpleCodec(SacrificialBowlBlock::new);
    private static final DirectionalBlockShape SHAPE = new DirectionalBlockShape(10.0f, 10.0f, 6.0f, 8.0f, 2.0f);

    public SacrificialBowlBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity != null) {
                StorageUtil.dropInventoryItems(blockEntity);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide) {
            ItemStack heldItem = pPlayer.getItemInHand(pHand);
            SacrificialBowlBlockEntity bowl = (SacrificialBowlBlockEntity)pLevel.getBlockEntity(pPos);
            ItemStackHandler handler = bowl.itemStackHandler;
            if (!pPlayer.isShiftKeyDown()) {
                ItemStack itemStack = handler.getStackInSlot(0);
                if (itemStack.isEmpty()) {
                    pPlayer.setItemInHand(pHand, handler.insertItem(0, heldItem, false));
                    pLevel.playSound(null, pPos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    if (heldItem.isEmpty()) {
                        pPlayer.setItemInHand(pHand, handler.extractItem(0, 64, false));
                    } else {
                        ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)handler.extractItem(0, 64, false));
                    }
                    pLevel.playSound(null, pPos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                bowl.setChanged();
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.isClientSide && level.getBlockState(pos).is((Block)this) && level.hasNeighborSignal(pos) && (blockEntity = level.getBlockEntity(pos)) instanceof SacrificialBowlBlockEntity) {
            SacrificialBowlBlockEntity bowl = (SacrificialBowlBlockEntity)blockEntity;
            blockEntity = level.getBlockEntity(pos.below());
            if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
                ChiseledBookShelfBlockEntity bookShelf = (ChiseledBookShelfBlockEntity)blockEntity;
                if (bowl.itemStackHandler.getStackInSlot(0).getItem() instanceof GuideBookItem) {
                    for (int i = 0; i < 6; ++i) {
                        Item item = bookShelf.getItem(i).getItem();
                        if (!(item instanceof BookOfBindingItem)) continue;
                        BookOfBindingItem book = (BookOfBindingItem)item;
                        bookShelf.setItem(i, BoundBookOfBindingRecipe.bookshelfCraft(book.getDefaultInstance(), bowl.itemStackHandler.getStackInSlot(0)));
                    }
                }
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE.getShape((Direction)state.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(direction.getOpposite()));
        return blockstate.is((Block)this) && blockstate.getValue((Property)FACING) == direction ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return OccultismBlockEntities.SACRIFICIAL_BOWL.get().create(blockPos, blockState);
    }
}

