/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.GreedyFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.GreedyFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class GreedyFamiliarRenderer
extends MobRenderer<GreedyFamiliarEntity, GreedyFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/greedy_familiar.png");

    public GreedyFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GreedyFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_GREEDY)), 0.3f);
        this.addLayer(new ItemLayer((RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel>)this));
        this.addLayer(new GreedyFamiliarChest((RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(GreedyFamiliarEntity entity) {
        return TEXTURES;
    }

    public void render(GreedyFamiliarEntity entityIn, float entityYaw, float partialTicks, PoseStack pMatrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        pMatrixStack.pushPose();
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            pMatrixStack.translate(0.0, -0.25, 0.0);
        }
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, pMatrixStack, bufferIn, packedLightIn);
        pMatrixStack.popPose();
    }

    private static class ItemLayer
    extends RenderLayer<GreedyFamiliarEntity, GreedyFamiliarModel> {
        public ItemLayer(RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, GreedyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            boolean hasBlacksmithUpgrade = pLivingEntity.hasBlacksmithUpgrade();
            ItemStack offhand = pLivingEntity.getOffhandItem();
            if (!hasBlacksmithUpgrade && offhand.isEmpty()) {
                return;
            }
            GreedyFamiliarModel model = (GreedyFamiliarModel)this.getParentModel();
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            pMatrixStack.pushPose();
            if (hasBlacksmithUpgrade) {
                model.body.translateAndRotate(pMatrixStack);
                model.rightArm.translateAndRotate(pMatrixStack);
                pMatrixStack.translate(-0.06, 0.2, -0.1);
                pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 1.5707964f, -0.7853982f));
                renderer.renderItem((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.IRON_PICKAXE), ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.popPose();
            }
            if (!offhand.isEmpty()) {
                pMatrixStack.pushPose();
                model.body.translateAndRotate(pMatrixStack);
                model.leftArm.translateAndRotate(pMatrixStack);
                pMatrixStack.translate(0.06, 0.2, -0.17);
                pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.7853982f, 0.0f));
                float size = 0.75f;
                pMatrixStack.scale(size, size, size);
                renderer.renderItem((LivingEntity)pLivingEntity, offhand, ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
                pMatrixStack.popPose();
            }
        }
    }

    private static class GreedyFamiliarChest
    extends RenderLayer<GreedyFamiliarEntity, GreedyFamiliarModel> {
        private static final ResourceLocation CHEST = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/greedy_familiar_chest.png");
        private static final ResourceLocation CHRISTMAS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/greedy_familiar_christmas.png");

        public GreedyFamiliarChest(RenderLayerParent<GreedyFamiliarEntity, GreedyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GreedyFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isInvisible()) {
                return;
            }
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)(FamiliarUtil.isChristmas() ? CHRISTMAS : CHEST)));
            GreedyFamiliarModel model = (GreedyFamiliarModel)this.getParentModel();
            model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
        }
    }
}

