/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.CthulhuFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.CthulhuFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class CthulhuFamiliarRenderer
extends MobRenderer<CthulhuFamiliarEntity, CthulhuFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/cthulhu_familiar.png");

    public CthulhuFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CthulhuFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_CTHULHU)), 0.3f);
        this.addLayer(new HeldItemLayer(this, (RenderLayerParent<CthulhuFamiliarEntity, CthulhuFamiliarModel>)this));
    }

    public void render(CthulhuFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        if (pEntity.isPartying()) {
            float ageInTicks = (float)pEntity.tickCount + pPartialTicks;
            pMatrixStack.translate(0.0, 1.55, 0.0);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(ageInTicks * 3.0f * ((float)Math.PI / 180), 0.0f, 0.0f));
            pMatrixStack.translate(0.0, 0.5, 0.0);
            pEntity.yBodyRotO = -180.0f;
            pEntity.yBodyRot = -180.0f;
        } else {
            pMatrixStack.translate(0.0, pEntity.isSitting() ? -0.35 : (double)pEntity.getAnimationHeight(pPartialTicks) * 0.08, 0.0);
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.popPose();
    }

    public ResourceLocation getTextureLocation(CthulhuFamiliarEntity entity) {
        return TEXTURES;
    }

    public class HeldItemLayer
    extends RenderLayer<CthulhuFamiliarEntity, CthulhuFamiliarModel> {
        public HeldItemLayer(CthulhuFamiliarRenderer this$0, RenderLayerParent<CthulhuFamiliarEntity, CthulhuFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack matrixStack, MultiBufferSource pBuffer, int pPackedLight, CthulhuFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isGiving()) {
                matrixStack.pushPose();
                matrixStack.scale(1.25f, -1.25f, 1.25f);
                matrixStack.translate(0.0, -0.75, -0.35);
                matrixStack.mulPose(new Quaternionf().rotateXYZ(-1.134464f, 0.0f, 0.0f));
                Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.POPPY), ItemDisplayContext.GROUND, false, matrixStack, pBuffer, pPackedLight);
                matrixStack.popPose();
            }
        }
    }
}

