/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.DeerFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DeerFamiliarModel
extends EntityModel<DeerFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart leftFrontLeg1;
    public ModelPart tail;
    public ModelPart neck;
    public ModelPart rightFrontLeg1;
    public ModelPart leftBackLeg1;
    public ModelPart rightBackLeg1;
    public ModelPart leftFrontLeg2;
    public ModelPart head;
    public ModelPart nose;
    public ModelPart leftEar;
    public ModelPart rightEar;
    public ModelPart leftHorn1;
    public ModelPart rightHorn1;
    public ModelPart hammerHandle;
    public ModelPart hammerHead;
    public ModelPart hammerSpikes1;
    public ModelPart hammerSpikes2;
    public ModelPart hammerSpikes3;
    public ModelPart hammerSpikes4;
    public ModelPart hammerSpikes5;
    public ModelPart hammerSpikes6;
    public ModelPart hammerSpikes7;
    public ModelPart hammerSpikes8;
    public ModelPart leftHorn2;
    public ModelPart leftHorn3;
    public ModelPart rightHorn2;
    public ModelPart rightHorn3;
    public ModelPart rightFrontLeg2;
    public ModelPart leftBackLeg2;
    public ModelPart rightBackLeg2;

    public DeerFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.leftFrontLeg1 = this.body.getChild("leftFrontLeg1");
        this.tail = this.body.getChild("tail");
        this.neck = this.body.getChild("neck");
        this.rightFrontLeg1 = this.body.getChild("rightFrontLeg1");
        this.leftBackLeg1 = this.body.getChild("leftBackLeg1");
        this.rightBackLeg1 = this.body.getChild("rightBackLeg1");
        this.leftFrontLeg2 = this.leftFrontLeg1.getChild("leftFrontLeg2");
        this.head = this.neck.getChild("head");
        this.nose = this.head.getChild("nose");
        this.leftEar = this.head.getChild("leftEar");
        this.rightEar = this.head.getChild("rightEar");
        this.leftHorn1 = this.head.getChild("leftHorn1");
        this.rightHorn1 = this.head.getChild("rightHorn1");
        this.hammerHandle = this.nose.getChild("hammerHandle");
        this.hammerHead = this.hammerHandle.getChild("hammerHead");
        this.hammerSpikes1 = this.hammerHead.getChild("hammerSpikes1");
        this.hammerSpikes2 = this.hammerHead.getChild("hammerSpikes2");
        this.hammerSpikes3 = this.hammerHead.getChild("hammerSpikes3");
        this.hammerSpikes4 = this.hammerHead.getChild("hammerSpikes4");
        this.hammerSpikes5 = this.hammerHead.getChild("hammerSpikes5");
        this.hammerSpikes6 = this.hammerHead.getChild("hammerSpikes6");
        this.hammerSpikes7 = this.hammerHead.getChild("hammerSpikes7");
        this.hammerSpikes8 = this.hammerHead.getChild("hammerSpikes8");
        this.leftHorn2 = this.leftHorn1.getChild("leftHorn2");
        this.leftHorn3 = this.leftHorn1.getChild("leftHorn3");
        this.rightHorn2 = this.rightHorn1.getChild("rightHorn2");
        this.rightHorn3 = this.rightHorn1.getChild("rightHorn3");
        this.rightFrontLeg2 = this.rightFrontLeg1.getChild("rightFrontLeg2");
        this.leftBackLeg2 = this.leftBackLeg1.getChild("leftBackLeg2");
        this.rightBackLeg2 = this.rightBackLeg1.getChild("rightBackLeg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -5.0f, -5.0f, 4.0f, 5.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)16.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg1 = body.addOrReplaceChild("leftFrontLeg1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.4f, (float)-0.2f, (float)-3.9f, (float)(-DeerFamiliarModel.toRad(80.0f)), (float)(-DeerFamiliarModel.toRad(10.0f)), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)4.5f, (float)-0.43633232f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(30, 0).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-4.0f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg1 = body.addOrReplaceChild("rightFrontLeg1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.4f, (float)-0.2f, (float)-3.9f, (float)(-DeerFamiliarModel.toRad(80.0f)), (float)(-DeerFamiliarModel.toRad(10.0f)), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition leftBackLeg1 = body.addOrReplaceChild("leftBackLeg1", CubeListBuilder.create().texOffs(28, 9).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.4f, (float)-0.2f, (float)3.9f, (float)DeerFamiliarModel.toRad(80.0f), (float)DeerFamiliarModel.toRad(10.0f), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition rightBackLeg1 = body.addOrReplaceChild("rightBackLeg1", CubeListBuilder.create().texOffs(28, 9).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.4f, (float)-0.2f, (float)3.9f, (float)DeerFamiliarModel.toRad(80.0f), (float)DeerFamiliarModel.toRad(10.0f), (float)(-DeerFamiliarModel.toRad(40.0f))));
        PartDefinition leftFrontLeg2 = leftFrontLeg1.addOrReplaceChild("leftFrontLeg2", CubeListBuilder.create().texOffs(18, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)3.8f, (float)0.0f, (float)0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(38, 0).addBox(-1.5f, -3.0f, -1.5f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)-0.3f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(51, 5).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.01f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(22, 3).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)-2.5f, (float)0.5f, (float)-0.39095375f, (float)0.0f, (float)0.7819075f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(22, 3).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)-2.5f, (float)0.5f, (float)-0.39095375f, (float)0.0f, (float)-0.7819075f));
        PartDefinition leftHorn1 = head.addOrReplaceChild("leftHorn1", CubeListBuilder.create().texOffs(50, 4).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.7f, (float)-2.5f, (float)0.3f, (float)0.0f, (float)0.0f, (float)0.312763f));
        PartDefinition rightHorn1 = head.addOrReplaceChild("rightHorn1", CubeListBuilder.create().texOffs(50, 4).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.7f, (float)-2.5f, (float)0.3f, (float)0.0f, (float)0.0f, (float)-0.312763f));
        PartDefinition hammerHandle = nose.addOrReplaceChild("hammerHandle", CubeListBuilder.create().texOffs(38, 14).addBox(0.0f, -0.5f, -0.5f, 5.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-1.8f, (float)0.3f, (float)-1.3f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hammerHead = hammerHandle.addOrReplaceChild("hammerHead", CubeListBuilder.create().texOffs(50, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition hammerSpikes1 = hammerHead.addOrReplaceChild("hammerSpikes1", CubeListBuilder.create().texOffs(58, 10).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)-0.2f, (float)-1.2f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes2 = hammerHead.addOrReplaceChild("hammerSpikes2", CubeListBuilder.create().texOffs(58, 10).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.2f, (float)-1.2f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes3 = hammerHead.addOrReplaceChild("hammerSpikes3", CubeListBuilder.create().texOffs(58, 10).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.2f, (float)-0.3f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes4 = hammerHead.addOrReplaceChild("hammerSpikes4", CubeListBuilder.create().texOffs(58, 10).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.2f, (float)0.3f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition hammerSpikes5 = hammerHead.addOrReplaceChild("hammerSpikes5", CubeListBuilder.create().texOffs(58, 9).addBox(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.5f, (float)-0.2f, (float)1.2f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition hammerSpikes6 = hammerHead.addOrReplaceChild("hammerSpikes6", CubeListBuilder.create().texOffs(58, 9).addBox(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.4f, (float)0.3f, (float)1.2f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition hammerSpikes7 = hammerHead.addOrReplaceChild("hammerSpikes7", CubeListBuilder.create().texOffs(58, 9).addBox(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.6f, (float)1.2f, (float)-0.1f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition hammerSpikes8 = hammerHead.addOrReplaceChild("hammerSpikes8", CubeListBuilder.create().texOffs(58, 9).addBox(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.5f, (float)1.2f, (float)0.3f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn2 = leftHorn1.addOrReplaceChild("leftHorn2", CubeListBuilder.create().texOffs(58, 0).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.3f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.134464f));
        PartDefinition leftHorn3 = leftHorn1.addOrReplaceChild("leftHorn3", CubeListBuilder.create().texOffs(18, 5).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.7f, (float)0.0f, (float)0.5864306f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn2 = rightHorn1.addOrReplaceChild("rightHorn2", CubeListBuilder.create().texOffs(58, 0).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.3f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.134464f));
        PartDefinition rightHorn3 = rightHorn1.addOrReplaceChild("rightHorn3", CubeListBuilder.create().texOffs(18, 5).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.7f, (float)0.0f, (float)0.5864306f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg2 = rightFrontLeg1.addOrReplaceChild("rightFrontLeg2", CubeListBuilder.create().texOffs(18, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)3.8f, (float)0.0f, (float)0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg2 = leftBackLeg1.addOrReplaceChild("leftBackLeg2", CubeListBuilder.create().texOffs(34, 10).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)3.8f, (float)0.0f, (float)-0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLeg2 = rightBackLeg1.addOrReplaceChild("rightBackLeg2", CubeListBuilder.create().texOffs(34, 10).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)3.8f, (float)0.0f, (float)-0.11728612f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)16);
    }

    private static float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void prepareMobModel(DeerFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.neck.xRot = entityIn.getNeckRot(partialTick);
        this.hammerHandle.visible = entityIn.hasBlacksmithUpgrade();
    }

    public void setupAnim(DeerFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.isEating()) {
            this.head.xRot = Mth.cos((float)(ageInTicks * 0.8f)) * 0.2f;
            this.head.yRot = 0.0f;
        } else {
            this.head.yRot = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.head.xRot = headPitch * ((float)Math.PI / 180) * 0.5f;
        }
        if ((double)this.attackTime > 0.01) {
            this.head.yRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * DeerFamiliarModel.toRad(50.0f);
            this.head.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * DeerFamiliarModel.toRad(-40.0f);
            this.nose.yRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * DeerFamiliarModel.toRad(18.0f);
            this.nose.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * DeerFamiliarModel.toRad(-18.0f);
        } else {
            this.head.zRot = 0.0f;
            this.nose.yRot = 0.0f;
            this.nose.zRot = 0.0f;
        }
        this.tail.xRot = Mth.cos((float)(limbSwing * 0.7f)) * 0.4f * limbSwingAmount - 0.3f;
        this.body.xRot = 0.0f;
        if (entityIn.isPartying()) {
            this.body.xRot = DeerFamiliarModel.toRad(-20.0f);
            this.setRotateAngle(this.rightBackLeg1, Mth.cos((float)(ageInTicks / 2.0f + (float)Math.PI)) * DeerFamiliarModel.toRad(5.0f) + DeerFamiliarModel.toRad(20.0f), 0.0f, 0.0f);
            this.setRotateAngle(this.leftBackLeg1, Mth.cos((float)(ageInTicks / 2.0f)) * DeerFamiliarModel.toRad(5.0f) + DeerFamiliarModel.toRad(20.0f), 0.0f, 0.0f);
            this.setRotateAngle(this.rightFrontLeg1, Mth.cos((float)(ageInTicks / 2.0f)) * DeerFamiliarModel.toRad(30.0f) - DeerFamiliarModel.toRad(40.0f), 0.0f, 0.0f);
            this.setRotateAngle(this.leftFrontLeg1, Mth.cos((float)(ageInTicks / 2.0f + (float)Math.PI)) * DeerFamiliarModel.toRad(30.0f) - DeerFamiliarModel.toRad(40.0f), 0.0f, 0.0f);
            this.rightBackLeg2.z = 0.0f;
            this.leftBackLeg2.z = 0.0f;
            this.rightFrontLeg2.z = 0.0f;
            this.leftFrontLeg2.z = 0.0f;
            this.rightBackLeg2.xRot = -0.1f;
            this.leftBackLeg2.xRot = -0.1f;
            this.rightFrontLeg2.xRot = 0.1f;
            this.leftFrontLeg2.xRot = 0.1f;
        } else if (entityIn.isSitting()) {
            this.setRotateAngle(this.rightBackLeg1, DeerFamiliarModel.toRad(80.0f), DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.setRotateAngle(this.leftBackLeg1, DeerFamiliarModel.toRad(80.0f), DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.setRotateAngle(this.rightFrontLeg1, -DeerFamiliarModel.toRad(80.0f), -DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.setRotateAngle(this.leftFrontLeg1, -DeerFamiliarModel.toRad(80.0f), -DeerFamiliarModel.toRad(10.0f), -DeerFamiliarModel.toRad(40.0f));
            this.rightBackLeg2.z = -0.5f;
            this.leftBackLeg2.z = -0.5f;
            this.rightFrontLeg2.z = 0.5f;
            this.leftFrontLeg2.z = 0.5f;
            this.rightBackLeg2.xRot = -DeerFamiliarModel.toRad(150.0f);
            this.leftBackLeg2.xRot = -DeerFamiliarModel.toRad(150.0f);
            this.rightFrontLeg2.xRot = DeerFamiliarModel.toRad(150.0f);
            this.leftFrontLeg2.xRot = DeerFamiliarModel.toRad(150.0f);
        } else {
            boolean fast = entityIn.getAttributeValue(Attributes.MOVEMENT_SPEED) > 0.4;
            this.setRotateAngle(this.rightBackLeg1, Mth.cos((float)(limbSwing * 0.7f + (fast ? (float)Math.PI : 0.0f))) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setRotateAngle(this.leftBackLeg1, Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setRotateAngle(this.rightFrontLeg1, Mth.cos((float)(limbSwing * 0.7f + (fast ? 0.0f : (float)Math.PI))) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setRotateAngle(this.leftFrontLeg1, Mth.cos((float)(limbSwing * 0.7f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.rightBackLeg2.z = 0.0f;
            this.leftBackLeg2.z = 0.0f;
            this.rightFrontLeg2.z = 0.0f;
            this.leftFrontLeg2.z = 0.0f;
            this.rightBackLeg2.xRot = -0.1f;
            this.leftBackLeg2.xRot = -0.1f;
            this.rightFrontLeg2.xRot = 0.1f;
            this.leftFrontLeg2.xRot = 0.1f;
        }
    }

    public void setRotateAngle(ModelPart ModelPart2, float x, float y, float z) {
        ModelPart2.xRot = x;
        ModelPart2.yRot = y;
        ModelPart2.zRot = z;
    }
}

